/*
 * Decompiled with CFR 0.152.
 */
package br.com.arkanis.arkanyamon.network;

import br.com.arkanis.arkanyamon.Arkanyamon;
import br.com.arkanis.arkanyamon.game.ArkaniaCard;
import br.com.arkanis.arkanyamon.game.ArkaniaGame;
import br.com.arkanis.arkanyamon.menu.ArkaniaGameMenu;
import br.com.arkanis.arkanyamon.sound.ModSounds;
import dev.lucaargolo.charta.game.Card;
import dev.lucaargolo.charta.game.CardPlayer;
import dev.lucaargolo.charta.game.GameSlot;
import dev.lucaargolo.charta.mixed.LivingEntityMixed;
import io.netty.buffer.ByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.jetbrains.annotations.NotNull;

public record ChargePayload(int card, int target) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<ChargePayload> TYPE = new CustomPacketPayload.Type(Arkanyamon.id("charge"));
    public static final StreamCodec<ByteBuf, ChargePayload> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.INT, ChargePayload::card, (StreamCodec)ByteBufCodecs.INT, ChargePayload::target, ChargePayload::new);

    public static void handleServer(ChargePayload payload, IPayloadContext context) {
        context.enqueueWork(() -> {
            Player sender = context.player();
            if (sender instanceof LivingEntityMixed) {
                LivingEntityMixed mixed = (LivingEntityMixed)sender;
                AbstractContainerMenu patt0$temp = sender.containerMenu;
                if (patt0$temp instanceof ArkaniaGameMenu) {
                    ArkaniaGameMenu menu = (ArkaniaGameMenu)patt0$temp;
                    CardPlayer player = mixed.charta_getCardPlayer();
                    ArkaniaGame game = (ArkaniaGame)menu.getGame();
                    if (game.getCurrentPlayer() == player) {
                        ArkaniaCard c;
                        Card patt2$temp;
                        ArkaniaCard active;
                        ArkaniaCard c2;
                        Card patt1$temp;
                        GameSlot hand = game.getPlayerHand(player);
                        ArkaniaCard card = payload.card > -1 && hand.size() > payload.card && (patt1$temp = hand.get(payload.card)) instanceof ArkaniaCard ? (c2 = (ArkaniaCard)patt1$temp) : null;
                        if (card != null && (active = payload.target > -1 && hand.size() > payload.target && (patt2$temp = hand.get(payload.target)) instanceof ArkaniaCard ? (c = (ArkaniaCard)patt2$temp) : (ArkaniaCard)game.getActiveCard(player).orElse(null)) != null && card.isEnergy() && card.element() == active.element()) {
                            if (payload.target > -1 && active.isEnergy()) {
                                hand.remove(payload.target);
                                game.play(player, (Component)Component.literal((String)"Descartou ").append(active.getName()));
                            } else if (!game.hasUsedEnergy()) {
                                hand.remove(payload.card);
                                game.play(player, (Component)Component.literal((String)"Adicionou energia a ").append(active.getName()));
                                active.setEnergy(active.getEnergy() + 1);
                                game.setUsedEnergy(true);
                                player.playSound((SoundEvent)ModSounds.CHARGE.get());
                            }
                        }
                    }
                }
            }
        });
    }

    @NotNull
    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

