/*
 * Decompiled with CFR 0.152.
 */
package br.com.arkanis.arkanyamon.network;

import br.com.arkanis.arkanyamon.Arkanyamon;
import br.com.arkanis.arkanyamon.game.ArkaniaCard;
import br.com.arkanis.arkanyamon.game.ArkaniaGame;
import br.com.arkanis.arkanyamon.menu.ArkaniaGameMenu;
import dev.lucaargolo.charta.game.Card;
import dev.lucaargolo.charta.game.CardPlayer;
import dev.lucaargolo.charta.game.GameSlot;
import dev.lucaargolo.charta.mixed.LivingEntityMixed;
import dev.lucaargolo.charta.sound.ModSounds;
import io.netty.buffer.ByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.jetbrains.annotations.NotNull;

public record ActivatePayload(int index) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<ActivatePayload> TYPE = new CustomPacketPayload.Type(Arkanyamon.id("activate"));
    public static final StreamCodec<ByteBuf, ActivatePayload> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.INT, ActivatePayload::index, ActivatePayload::new);

    public static void handleServer(ActivatePayload payload, IPayloadContext context) {
        context.enqueueWork(() -> {
            Player sender = context.player();
            if (sender instanceof LivingEntityMixed) {
                LivingEntityMixed mixed = (LivingEntityMixed)sender;
                AbstractContainerMenu patt0$temp = sender.containerMenu;
                if (patt0$temp instanceof ArkaniaGameMenu) {
                    ArkaniaGameMenu menu = (ArkaniaGameMenu)patt0$temp;
                    CardPlayer player = mixed.charta_getCardPlayer();
                    ArkaniaGame game = (ArkaniaGame)menu.getGame();
                    ActivatePayload.activateCard(game, player, payload.index);
                }
            }
        });
    }

    public static void activateCard(ArkaniaGame game, CardPlayer player, int index) {
        if (game.getCurrentPlayer() == player) {
            Card card;
            GameSlot hand = game.getPlayerHand(player);
            if (index > -1 && hand.size() > index && (card = hand.remove(index)) instanceof ArkaniaCard) {
                ArkaniaCard card2 = (ArkaniaCard)card;
                GameSlot active = game.getActiveSlot(player);
                game.getActiveCard(player).ifPresentOrElse(removed -> {
                    active.clear();
                    game.play(player, (Component)Component.literal((String)"Recuou ").append(removed.getName()));
                    player.playSound((SoundEvent)ModSounds.CARD_DRAW.get());
                    hand.add((Card)removed);
                    active.add((Card)card2);
                }, () -> active.add((Card)card2));
                game.play(player, (Component)Component.literal((String)"Ativou ").append(card2.getName()));
                player.playSound((SoundEvent)ModSounds.CARD_PLAY.get());
            }
        }
    }

    @NotNull
    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

