/*
 * Decompiled with CFR 0.152.
 */
package br.com.arkanis.arkanyamon.network;

import br.com.arkanis.arkanyamon.Arkanyamon;
import br.com.arkanis.arkanyamon.game.ArkaniaCard;
import br.com.arkanis.arkanyamon.game.ArkaniaGame;
import br.com.arkanis.arkanyamon.game.Effect;
import br.com.arkanis.arkanyamon.game.actions.Action;
import br.com.arkanis.arkanyamon.menu.ArkaniaGameMenu;
import dev.lucaargolo.charta.game.Card;
import dev.lucaargolo.charta.game.CardPlay;
import dev.lucaargolo.charta.game.CardPlayer;
import dev.lucaargolo.charta.game.GameSlot;
import dev.lucaargolo.charta.mixed.LivingEntityMixed;
import io.netty.buffer.ByteBuf;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.jetbrains.annotations.NotNull;

public record ActionPayload(int card, int target, int action) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<ActionPayload> TYPE = new CustomPacketPayload.Type(Arkanyamon.id("action"));
    public static final StreamCodec<ByteBuf, ActionPayload> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.INT, ActionPayload::card, (StreamCodec)ByteBufCodecs.INT, ActionPayload::target, (StreamCodec)ByteBufCodecs.INT, ActionPayload::action, ActionPayload::new);

    public static void handleServer(ActionPayload payload, IPayloadContext context) {
        context.enqueueWork(() -> {
            Player sender = context.player();
            if (sender instanceof LivingEntityMixed) {
                LivingEntityMixed mixed = (LivingEntityMixed)sender;
                AbstractContainerMenu patt0$temp = sender.containerMenu;
                if (patt0$temp instanceof ArkaniaGameMenu) {
                    ArkaniaGameMenu menu = (ArkaniaGameMenu)patt0$temp;
                    ArkaniaGame game = (ArkaniaGame)menu.getGame();
                    CardPlayer player = mixed.charta_getCardPlayer();
                    CardPlayer enemy = game.getOpponent(player);
                    if (game.getCurrentPlayer() == player) {
                        ArkaniaCard c;
                        Card patt1$temp;
                        GameSlot hand = game.getPlayerHand(player);
                        ArkaniaCard card = payload.card > -1 && hand.size() > payload.card && (patt1$temp = hand.get(payload.card)) instanceof ArkaniaCard ? (c = (ArkaniaCard)patt1$temp) : (ArkaniaCard)game.getActiveCard(player).orElse(null);
                        if (card != null && payload.action < card.actions().length) {
                            ArkaniaCard c2;
                            Card patt3$temp;
                            ArkaniaCard c3;
                            Card patt2$temp;
                            Action action = card.actions()[payload.action];
                            GameSlot targets = game.getPlayerHand(enemy);
                            ArkaniaCard target = action.getChooseAction() == Action.Choose.CHOOSE_ENEMY && payload.target > -1 && targets.size() > payload.target && (patt2$temp = targets.get(payload.target)) instanceof ArkaniaCard ? (c3 = (ArkaniaCard)patt2$temp) : (action.getChooseAction() == Action.Choose.CHOOSE_FRIENDLY && payload.target > -1 && hand.size() > payload.target && (patt3$temp = hand.get(payload.target)) instanceof ArkaniaCard ? (c2 = (ArkaniaCard)patt3$temp) : null);
                            boolean attacking = action.isAttackAction();
                            boolean ability = !attacking && card.isSpecialist();
                            boolean item = !attacking && card.isItem();
                            boolean validPlay = attacking || ability && !game.hasUsedAbility() || item && !game.hasUsedItem();
                            boolean validAction = action.canExecute(card, player, game, target);
                            if (validPlay && validAction) {
                                if (card.getEffect() == Effect.TORTO) {
                                    game.play(player, (Component)Component.literal((String)"O especialista est\u00e1 torto"));
                                } else if (card.getEffect() == Effect.ATORDOADO) {
                                    game.play(player, (Component)Component.literal((String)"O especialista est\u00e1 atordoado"));
                                } else if (card.getEffect() == Effect.ADORMECIDO && Math.random() > 0.5) {
                                    game.play(player, (Component)Component.literal((String)"O especialista esqueceu de acordar"));
                                } else {
                                    Component name = card.isItem() ? player.getName() : card.getName();
                                    game.play(player, (Component)Component.empty().append(name).append(" usou ").append(action.getName(card)));
                                    action.execute(card, player, game, target);
                                }
                                if (!action.isAttackAction()) {
                                    if (card.isSpecialist()) {
                                        game.setUsedAbility(true);
                                    } else {
                                        game.setUsedItem(true);
                                        if (payload.card > -1) {
                                            hand.remove(payload.card);
                                        }
                                    }
                                }
                                player.play(new CardPlay(List.of(card), payload.action));
                            }
                        }
                    }
                }
            }
        });
    }

    @NotNull
    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

