/*
 * Decompiled with CFR 0.152.
 */
package br.com.arkanis.arkanyamon.mixin;

import br.com.arkanis.arkanyamon.Arkanyamon;
import br.com.arkanis.arkanyamon.game.ArkaniaCard;
import br.com.arkanis.arkanyamon.game.ArkaniaDeck;
import br.com.arkanis.arkanyamon.game.ArkaniaPack;
import dev.lucaargolo.charta.Charta;
import dev.lucaargolo.charta.client.ChartaClient;
import dev.lucaargolo.charta.utils.CardImageUtils;
import java.util.Collection;
import java.util.Objects;
import java.util.stream.Collectors;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ChartaClient.class}, remap=false)
public class ChartaClientMixin {
    @Inject(at={@At(value="TAIL")}, method={"generateImages"})
    private static void generateImages(CallbackInfo ci) {
        Collection<ArkaniaPack> packs = ArkaniaPack.values();
        Collection<ArkaniaCard> cards = ArkaniaCard.values();
        Arkanyamon.LOGGER.info("Injecting " + cards.size() + " Arkanyamon cards from " + packs.size() + " packs");
        ArkaniaDeck.INSTANCE = new ArkaniaDeck(cards);
        Collection suits = cards.stream().map(ArkaniaCard::element).filter(Objects::nonNull).collect(Collectors.toSet());
        suits.forEach(suit -> Charta.SUIT_IMAGES.getImages().put(suit.texture(), CardImageUtils.EMPTY_SUIT));
        cards.forEach(arkaniaCard -> Charta.CARD_IMAGES.getImages().put(arkaniaCard.texture(), CardImageUtils.EMPTY_CARD));
        Charta.DECK_IMAGES.getImages().put(ArkaniaDeck.IMAGE, CardImageUtils.EMPTY_CARD);
    }
}

