/*
 * Decompiled with CFR 0.152.
 */
package br.com.arkanis.arkanyamon.mixin;

import br.com.arkanis.arkanyamon.game.ArkaniaCard;
import br.com.arkanis.arkanyamon.game.Effect;
import br.com.arkanis.arkanyamon.game.TransmutableCard;
import dev.lucaargolo.charta.game.Card;
import io.netty.buffer.ByteBuf;
import java.nio.charset.StandardCharsets;
import net.minecraft.network.codec.StreamCodec;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Card.class})
public class CardMixin {
    @Shadow
    @Final
    @Mutable
    public static StreamCodec<ByteBuf, Card> STREAM_CODEC;

    @Inject(at={@At(value="TAIL")}, method={"<clinit>"})
    private static void card(CallbackInfo ci) {
        final StreamCodec<ByteBuf, Card> codec = STREAM_CODEC;
        STREAM_CODEC = new StreamCodec<ByteBuf, Card>(){

            @NotNull
            public Card decode(@NotNull ByteBuf buffer) {
                Card original = (Card)codec.decode((Object)buffer);
                boolean isArkania = buffer.readBoolean();
                if (isArkania) {
                    int nameLength = buffer.readInt();
                    byte[] nameBytes = new byte[nameLength];
                    buffer.readBytes(nameBytes);
                    String name = new String(nameBytes, StandardCharsets.UTF_8);
                    ArkaniaCard card = ArkaniaCard.loadOrThrow(name).copy();
                    if (card.flipped() != buffer.readBoolean()) {
                        card.flip();
                    }
                    card.setHealth(buffer.readInt());
                    card.setEnergy(buffer.readInt());
                    card.setEffect(Effect.values()[buffer.readInt()]);
                    return card;
                }
                return original;
            }

            public void encode(@NotNull ByteBuf buffer, @NotNull Card value) {
                codec.encode((Object)buffer, (Object)value);
                if (value instanceof ArkaniaCard) {
                    byte[] nameBytes;
                    ArkaniaCard arkaniaCard = (ArkaniaCard)value;
                    buffer.writeBoolean(true);
                    if (arkaniaCard instanceof TransmutableCard) {
                        TransmutableCard transmutableCard = (TransmutableCard)arkaniaCard;
                        String transmutableName = transmutableCard.getTransmutations().get((Object)transmutableCard.getElement()) != null && transmutableCard.getTransmutations().get((Object)transmutableCard.getElement()) != transmutableCard ? transmutableCard.getTransmutations().get((Object)transmutableCard.getElement()).name() : arkaniaCard.name();
                        nameBytes = transmutableName.getBytes(StandardCharsets.UTF_8);
                    } else {
                        nameBytes = arkaniaCard.name().getBytes(StandardCharsets.UTF_8);
                    }
                    buffer.writeInt(nameBytes.length);
                    buffer.writeBytes(nameBytes);
                    buffer.writeBoolean(value.flipped());
                    buffer.writeInt(arkaniaCard.getHealth());
                    buffer.writeInt(arkaniaCard.getEnergy());
                    buffer.writeInt(arkaniaCard.getEffect().ordinal());
                } else {
                    buffer.writeBoolean(false);
                }
            }
        };
    }
}

