/*
 * Decompiled with CFR 0.152.
 */
package br.com.arkanis.arkanyamon.menu;

import br.com.arkanis.arkanyamon.Arkanyamon;
import br.com.arkanis.arkanyamon.game.ArkaniaCard;
import br.com.arkanis.arkanyamon.game.ArkaniaDeck;
import br.com.arkanis.arkanyamon.game.ArkaniaGame;
import br.com.arkanis.arkanyamon.game.actions.Action;
import br.com.arkanis.arkanyamon.menu.ModMenus;
import dev.lucaargolo.charta.game.CardGame;
import dev.lucaargolo.charta.game.CardGames;
import dev.lucaargolo.charta.game.CardPlayer;
import dev.lucaargolo.charta.game.Deck;
import dev.lucaargolo.charta.game.GameSlot;
import dev.lucaargolo.charta.menu.AbstractCardMenu;
import dev.lucaargolo.charta.menu.CardSlot;
import dev.lucaargolo.charta.menu.HandSlot;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ArkaniaGameMenu
extends AbstractCardMenu<ArkaniaGame> {
    private int firstRound = 0;
    private int usedEnergy = 0;
    private int usedAbility = 0;
    private int usedItem = 0;
    private final ContainerData data = new ContainerData(){

        public int get(int i) {
            return switch (i) {
                case 0 -> {
                    if (((ArkaniaGame)ArkaniaGameMenu.this.game).isFirstRound()) {
                        yield 1;
                    }
                    yield ArkaniaGameMenu.this.firstRound;
                }
                case 1 -> {
                    if (((ArkaniaGame)ArkaniaGameMenu.this.game).hasUsedEnergy()) {
                        yield 1;
                    }
                    yield ArkaniaGameMenu.this.usedEnergy;
                }
                case 2 -> {
                    if (((ArkaniaGame)ArkaniaGameMenu.this.game).hasUsedAbility()) {
                        yield 1;
                    }
                    yield ArkaniaGameMenu.this.usedAbility;
                }
                case 3 -> {
                    if (((ArkaniaGame)ArkaniaGameMenu.this.game).hasUsedItem()) {
                        yield 1;
                    }
                    yield ArkaniaGameMenu.this.usedItem;
                }
                case 4 -> ((ArkaniaGame)ArkaniaGameMenu.this.game).getVictories(ArkaniaGameMenu.this.cardPlayer);
                case 5 -> ((ArkaniaGame)ArkaniaGameMenu.this.game).getVictories(((ArkaniaGame)ArkaniaGameMenu.this.game).getOpponent(ArkaniaGameMenu.this.cardPlayer));
                default -> 0;
            };
        }

        public void set(int i, int value) {
            switch (i) {
                case 0: {
                    ArkaniaGameMenu.this.firstRound = value;
                    break;
                }
                case 1: {
                    ArkaniaGameMenu.this.usedEnergy = value;
                    break;
                }
                case 2: {
                    ArkaniaGameMenu.this.usedAbility = value;
                    break;
                }
                case 3: {
                    ArkaniaGameMenu.this.usedItem = value;
                    break;
                }
                case 4: {
                    ((ArkaniaGame)ArkaniaGameMenu.this.game).setVictories(ArkaniaGameMenu.this.cardPlayer, value);
                    break;
                }
                case 5: {
                    ((ArkaniaGame)ArkaniaGameMenu.this.game).setVictories(((ArkaniaGame)ArkaniaGameMenu.this.game).getOpponent(ArkaniaGameMenu.this.cardPlayer), value);
                }
            }
        }

        public int getCount() {
            return 6;
        }
    };

    public ArkaniaGameMenu(int containerId, Inventory inventory, FriendlyByteBuf buf) {
        this(containerId, inventory, ContainerLevelAccess.create((Level)inventory.player.level(), (BlockPos)buf.readBlockPos()), (ArkaniaDeck)((Object)Deck.STREAM_CODEC.decode((Object)buf)), buf.readVarIntArray(), buf.readByteArray());
    }

    public ArkaniaGameMenu(int containerId, Inventory inventory, ContainerLevelAccess access, ArkaniaDeck deck, int[] players, byte[] options) {
        super((MenuType)ModMenus.GAME.get(), containerId, inventory, access, (Deck)deck, players, options);
        for (int i = 0; i < players.length; ++i) {
            ArkaniaGame game = (ArkaniaGame)this.getGame();
            CardPlayer p = (CardPlayer)game.getPlayers().get(i);
            this.addCardSlot(new CardSlot((CardGame)game, g -> g.getPlayerHand(p), 0.0f, 7.0f, CardSlot.Type.PREVIEW));
        }
        this.addCardSlot(new CardSlot((CardGame)((ArkaniaGame)this.game), g -> g.getActiveSlot(this.cardPlayer), -999.0f, -999.0f));
        this.addCardSlot(new CardSlot((CardGame)((ArkaniaGame)this.game), g -> g.getDeckSlot(this.cardPlayer), -999.0f, -999.0f));
        this.addCardSlot((CardSlot)new HandSlot<ArkaniaGame>(this, (ArkaniaGame)this.game, g -> true, this.cardPlayer, 45.0f, -5.0f, CardSlot.Type.HORIZONTAL){

            public void postUpdate() {
                ((ArkaniaGame)this.game).postUpdate();
                this.getCensoredSlot().clear();
                this.getCensoredSlot().addAll(this.getSlot());
            }
        });
        this.addCardSlot(new CardSlot((CardGame)((ArkaniaGame)this.game), g -> g.getActiveSlot(g.getOpponent(this.cardPlayer)), -999.0f, -999.0f));
        this.addDataSlots(this.data);
    }

    public List<ArkaniaCard> getPlayerHand() {
        GameSlot handSlot = ((ArkaniaGame)this.game).getPlayerHand(this.cardPlayer);
        return handSlot.stream().filter(c -> c instanceof ArkaniaCard).map(c -> (ArkaniaCard)((Object)c)).toList();
    }

    public List<ArkaniaCard> getEnemyHand() {
        GameSlot handSlot = ((ArkaniaGame)this.game).getPlayerHand(((ArkaniaGame)this.game).getOpponent(this.cardPlayer));
        return handSlot.stream().filter(c -> c instanceof ArkaniaCard).map(c -> (ArkaniaCard)((Object)c)).toList();
    }

    @Nullable
    public ArkaniaCard getPlayerCard() {
        return ((ArkaniaGame)this.game).getActiveCard(this.cardPlayer).orElse(null);
    }

    @Nullable
    public ArkaniaCard getEnemyCard() {
        return ((ArkaniaGame)this.game).getActiveCard(((ArkaniaGame)this.game).getOpponent(this.cardPlayer)).orElse(null);
    }

    public int getPlayerVictories() {
        return this.data.get(4);
    }

    public int getEnemyVictories() {
        return this.data.get(5);
    }

    public boolean isFirstPlayer() {
        return ((ArkaniaGame)this.game).getPlayers().indexOf(this.cardPlayer) == 0;
    }

    public boolean isFirstRound() {
        return this.firstRound > 0;
    }

    public boolean hasUsedEnergy() {
        return this.usedEnergy > 0;
    }

    public boolean hasUsedAbility() {
        return this.usedAbility > 0;
    }

    public boolean hasUsedItem() {
        return this.usedItem > 0;
    }

    public CardGames.Factory<ArkaniaGame> getGameFactory() {
        return Arkanyamon.GAME;
    }

    @NotNull
    public ItemStack quickMoveStack(@NotNull Player player, int index) {
        return ItemStack.EMPTY;
    }

    public boolean stillValid(@NotNull Player player) {
        return this.game != null && this.cardPlayer != null && !((ArkaniaGame)this.game).isGameOver();
    }

    public void removed(@NotNull Player player) {
        super.removed(player);
        ((ArkaniaGame)this.game).getCensoredHand(this.cardPlayer).clear();
        ((ArkaniaGame)this.game).getCensoredHand(this.cardPlayer).addAll(((ArkaniaGame)this.game).getPlayerHand(this.cardPlayer));
    }

    public Map<ArkaniaCard, Integer> getAvailableSpecialists(Action.Choose chooseAction) {
        if (chooseAction == Action.Choose.ACTIVE_ONLY) {
            return Map.of();
        }
        ArkaniaCard card = chooseAction == Action.Choose.CHOOSE_FRIENDLY ? this.getPlayerCard() : this.getEnemyCard();
        LinkedHashMap<ArkaniaCard, Integer> map = new LinkedHashMap<ArkaniaCard, Integer>();
        if (card != null) {
            map.put(card, -1);
        }
        List<ArkaniaCard> hand = chooseAction == Action.Choose.CHOOSE_FRIENDLY ? this.getPlayerHand() : this.getEnemyHand();
        for (int index = 0; index < hand.size(); ++index) {
            ArkaniaCard target = hand.get(index);
            if (target.type() != ArkaniaCard.Type.SPECIALIST) continue;
            map.put(target, index);
        }
        return map;
    }
}

