/*
 * Decompiled with CFR 0.152.
 */
package br.com.arkanis.arkanyamon.menu;

import br.com.arkanis.arkanyamon.game.ArkaniaCard;
import br.com.arkanis.arkanyamon.item.ArkaniaCardItem;
import br.com.arkanis.arkanyamon.item.ArkaniaDeckItem;
import br.com.arkanis.arkanyamon.item.ModDataComponentTypes;
import br.com.arkanis.arkanyamon.item.ModItems;
import br.com.arkanis.arkanyamon.menu.ModMenus;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import org.jetbrains.annotations.NotNull;

public class ArkaniaDeckMenu
extends AbstractContainerMenu {
    private final SimpleContainer container;
    private ItemStack stack = null;

    public ArkaniaDeckMenu(int containerId, Inventory playerInventory, FriendlyByteBuf buf) {
        this(containerId, playerInventory);
    }

    public ArkaniaDeckMenu(int containerId, Inventory playerInventory) {
        super((MenuType)ModMenus.DECK.get(), containerId);
        int j;
        int i;
        for (InteractionHand hand : InteractionHand.values()) {
            this.stack = playerInventory.player.getItemInHand(hand);
            if (this.stack.getItem() instanceof ArkaniaDeckItem) break;
            this.stack = null;
        }
        ItemStack[] items = new ItemStack[30];
        if (this.stack != null) {
            items = ArkaniaDeckItem.getDeckItems(this.stack);
        } else {
            for (i = 0; i < 30; ++i) {
                items[i] = ItemStack.EMPTY;
            }
        }
        this.container = new SimpleContainer(this, items){

            public int getMaxStackSize() {
                return 1;
            }

            public boolean canPlaceItem(int index, @NotNull ItemStack stack) {
                return stack.is((Item)ModItems.CARD.get());
            }
        };
        this.container.addListener(this::updateStack);
        this.container.startOpen(playerInventory.player);
        for (i = 0; i < 6; ++i) {
            for (j = 0; j < 5; ++j) {
                this.addSlot(new Slot((Container)this.container, j + i * 5, 44 + j * 18, 7 + i * 18));
            }
        }
        for (i = 0; i < 3; ++i) {
            for (j = 0; j < 9; ++j) {
                this.addSlot(new Slot((Container)playerInventory, j + i * 9 + 9, 8 + j * 18, 136 + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.addSlot(new Slot((Container)playerInventory, i, 8 + i * 18, 194));
        }
    }

    public SimpleContainer getContainer() {
        return this.container;
    }

    public ItemStack getStack() {
        return this.stack;
    }

    public boolean stillValid(@NotNull Player player) {
        return this.stack != null && this.container.stillValid(player);
    }

    public void clicked(int slotId, int button, @NotNull ClickType clickType, @NotNull Player player) {
        if (slotId < 0 || slotId >= this.slots.size() || !((Slot)this.slots.get(slotId)).getItem().equals(this.stack)) {
            super.clicked(slotId, button, clickType, player);
        }
    }

    @NotNull
    public ItemStack quickMoveStack(@NotNull Player player, int index) {
        ItemStack itemStack = ItemStack.EMPTY;
        if (index >= 0 && index < this.slots.size() && ((Slot)this.slots.get(index)).getItem().equals(this.stack)) {
            return itemStack;
        }
        Slot slot = (Slot)this.slots.get(index);
        if (slot.hasItem()) {
            ItemStack itemStack2 = slot.getItem();
            itemStack = itemStack2.copy();
            if (index < 30 ? !this.moveItemStackTo(itemStack2, 30, 66, true) : !this.moveItemStackTo(itemStack2, 0, 30, false)) {
                return ItemStack.EMPTY;
            }
            if (itemStack2.isEmpty()) {
                slot.setByPlayer(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
            if (itemStack2.getCount() == itemStack.getCount()) {
                return ItemStack.EMPTY;
            }
            slot.onTake(player, itemStack2);
        }
        return itemStack;
    }

    public void removed(@NotNull Player player) {
        super.removed(player);
        this.container.stopOpen(player);
        this.updateStack((Container)this.container);
    }

    private void updateStack(Container container) {
        ListTag list = new ListTag();
        boolean full = false;
        for (int i = 0; i < 30; ++i) {
            ItemStack stack = container.getItem(i);
            if (stack.is((Item)ModItems.CARD.get())) {
                ArkaniaCard card = ArkaniaCardItem.getCard(stack);
                assert (card != null);
                list.add((Object)StringTag.valueOf((String)card.name()));
                full = true;
                continue;
            }
            list.add((Object)StringTag.valueOf((String)ArkaniaCard.BLANK.name()));
        }
        if (full) {
            CompoundTag tag = new CompoundTag();
            tag.put("ArkanyamonDeck", (Tag)list);
            this.stack.set(ModDataComponentTypes.ARKANIA_DECK, (Object)CustomData.of((CompoundTag)tag));
        } else {
            this.stack.remove(ModDataComponentTypes.ARKANIA_DECK);
        }
    }
}

