/*
 * Decompiled with CFR 0.152.
 */
package br.com.arkanis.arkanyamon.item;

import br.com.arkanis.arkanyamon.client.screen.PackOpenScreen;
import br.com.arkanis.arkanyamon.game.ArkaniaCard;
import br.com.arkanis.arkanyamon.game.ArkaniaPack;
import br.com.arkanis.arkanyamon.item.ArkaniaCardItem;
import br.com.arkanis.arkanyamon.item.ModDataComponentTypes;
import br.com.arkanis.arkanyamon.item.ModItems;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ThreadLocalRandom;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ArkaniaPackItem
extends Item {
    public ArkaniaPackItem(Item.Properties properties) {
        super(properties);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void openScreen(ItemStack stack) {
        Minecraft.getInstance().setScreen((Screen)new PackOpenScreen(stack));
    }

    @NotNull
    public Component getName(@NotNull ItemStack stack) {
        ArkaniaPack pack = ArkaniaPackItem.getPack(stack);
        if (pack != null) {
            return pack.getName();
        }
        return super.getName(stack);
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(@NotNull Level level, @NotNull Player player, @NotNull InteractionHand usedHand) {
        List<ArkaniaCard> cards;
        ItemStack stack = player.getItemInHand(usedHand);
        ArkaniaPack pack = ArkaniaPackItem.getPack(stack);
        if (pack != null && !(cards = ArkaniaPackItem.getCards(stack)).isEmpty() && level.isClientSide()) {
            this.openScreen(stack);
        }
        return InteractionResultHolder.success((Object)stack);
    }

    public void inventoryTick(@NotNull ItemStack stack, @NotNull Level level, @NotNull Entity entity, int slotId, boolean isSelected) {
        List<ArkaniaCard> cards;
        ArkaniaPack pack = ArkaniaPackItem.getPack(stack);
        if (pack != null && (cards = ArkaniaPackItem.getCards(stack)).isEmpty()) {
            ArkaniaPackItem.populateCards(pack, stack);
        }
    }

    public void appendHoverText(@NotNull ItemStack stack, @NotNull Item.TooltipContext context, @NotNull List<Component> tooltipComponents, @NotNull TooltipFlag tooltipFlag) {
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
        ArkaniaPack pack = ArkaniaPackItem.getPack(stack);
        if (pack != null) {
            tooltipComponents.add((Component)Component.literal((String)("Booster Pack (" + pack.code() + ")")).withStyle(new ChatFormatting[]{ChatFormatting.DARK_PURPLE, ChatFormatting.ITALIC}));
            tooltipComponents.add((Component)Component.literal((String)(pack.cards().stream().filter(ArkaniaCard::isSpecialist).count() + " Especialistas")).withStyle(ChatFormatting.LIGHT_PURPLE));
            tooltipComponents.add((Component)Component.literal((String)(pack.cards().stream().filter(ArkaniaCard::isEnergy).count() + " Energias")).withStyle(ChatFormatting.LIGHT_PURPLE));
            tooltipComponents.add((Component)Component.literal((String)(pack.cards().stream().filter(ArkaniaCard::isItem).count() + " Items")).withStyle(ChatFormatting.LIGHT_PURPLE));
        }
    }

    private static void populateCards(ArkaniaPack pack, ItemStack stack) {
        List<ArkaniaCard> energyCards = pack.cards().stream().filter(ArkaniaCard::isEnergy).toList();
        List<ArkaniaCard> specialistCards = pack.cards().stream().filter(ArkaniaCard::isSpecialist).toList();
        List<ArkaniaCard> itemCards = pack.cards().stream().filter(ArkaniaCard::isItem).toList();
        ArrayList<ArkaniaCard> selectedCards = new ArrayList<ArkaniaCard>();
        int chance = ThreadLocalRandom.current().nextInt(100);
        if (chance < 25) {
            selectedCards.addAll(ArkaniaPackItem.getRandomCards(energyCards, 4));
            selectedCards.addAll(ArkaniaPackItem.getRandomCards(specialistCards, 1));
        } else if (chance < 75 && !itemCards.isEmpty()) {
            selectedCards.addAll(ArkaniaPackItem.getRandomCards(energyCards, 3));
            selectedCards.addAll(ArkaniaPackItem.getRandomCards(specialistCards, 1));
            selectedCards.addAll(ArkaniaPackItem.getRandomCards(itemCards, 1));
        } else {
            selectedCards.addAll(ArkaniaPackItem.getRandomCards(energyCards, 3));
            selectedCards.addAll(ArkaniaPackItem.getRandomCards(specialistCards, 2));
        }
        ListTag list = new ListTag();
        for (ArkaniaCard card : selectedCards) {
            list.add((Object)StringTag.valueOf((String)card.name()));
        }
        CompoundTag tag = new CompoundTag();
        tag.put("PackCards", (Tag)list);
        stack.set(ModDataComponentTypes.ARKANIA_PACK_CARDS, (Object)CustomData.of((CompoundTag)tag));
    }

    private static List<ArkaniaCard> getRandomCards(List<ArkaniaCard> source, int count) {
        if (source.isEmpty()) {
            return List.of();
        }
        ArrayList<ArkaniaCard> result = new ArrayList<ArkaniaCard>();
        ThreadLocalRandom random = ThreadLocalRandom.current();
        for (int i = 0; i < count; ++i) {
            ArkaniaCard card = source.get(random.nextInt(source.size()));
            result.add(card);
        }
        return result;
    }

    @Nullable
    public static ArkaniaPack getPack(ItemStack stack) {
        String code = (String)stack.get(ModDataComponentTypes.ARKANIA_PACK);
        return code != null ? ArkaniaPack.load(code) : null;
    }

    public static ItemStack getPack(ArkaniaPack pack) {
        ItemStack stack = ((ArkaniaPackItem)((Object)ModItems.PACK.get())).getDefaultInstance();
        stack.set(ModDataComponentTypes.ARKANIA_PACK, (Object)pack.code());
        return stack;
    }

    public static List<ArkaniaCard> getCards(ItemStack stack) {
        CustomData data = (CustomData)stack.get(ModDataComponentTypes.ARKANIA_PACK_CARDS);
        CompoundTag nbt = data != null ? data.copyTag() : new CompoundTag();
        ListTag cards = nbt.getList("PackCards", 8);
        return cards.stream().map(Tag::getAsString).map(ArkaniaCard::load).filter(Objects::nonNull).filter(card -> card != ArkaniaCard.BLANK).map(ArkaniaCard::copy).toList();
    }

    public static ItemStack[] getCardItems(ItemStack stack) {
        CustomData data = (CustomData)stack.get(ModDataComponentTypes.ARKANIA_PACK_CARDS);
        CompoundTag nbt = data != null ? data.copyTag() : new CompoundTag();
        ListTag cards = nbt.getList("PackCards", 8);
        ItemStack[] items = new ItemStack[5];
        for (int i = 0; i < 5; ++i) {
            if (i < cards.size()) {
                ArkaniaCard card = ArkaniaCard.load(cards.get(i).getAsString());
                if (card != null && card != ArkaniaCard.BLANK) {
                    items[i] = ArkaniaCardItem.getCard(card);
                    continue;
                }
                items[i] = ItemStack.EMPTY;
                continue;
            }
            items[i] = ItemStack.EMPTY;
        }
        return items;
    }
}

