/*
 * Decompiled with CFR 0.152.
 */
package br.com.arkanis.arkanyamon.item;

import br.com.arkanis.arkanyamon.game.ArkaniaCard;
import br.com.arkanis.arkanyamon.game.ArkaniaDeck;
import br.com.arkanis.arkanyamon.item.ArkaniaCardItem;
import br.com.arkanis.arkanyamon.item.ModDataComponentTypes;
import br.com.arkanis.arkanyamon.menu.ArkaniaDeckMenu;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class ArkaniaDeckItem
extends Item {
    public ArkaniaDeckItem(Item.Properties properties) {
        super(properties);
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(@NotNull Level level, @NotNull Player player, @NotNull InteractionHand usedHand) {
        if (!level.isClientSide()) {
            player.openMenu(new MenuProvider(this){

                @NotNull
                public Component getDisplayName() {
                    return Component.literal((String)"Arkania Deck");
                }

                @NotNull
                public AbstractContainerMenu createMenu(int syncId, @NotNull Inventory playerInventory, @NotNull Player player) {
                    return new ArkaniaDeckMenu(syncId, playerInventory);
                }
            });
        }
        return InteractionResultHolder.success((Object)player.getItemInHand(usedHand));
    }

    public void appendHoverText(@NotNull ItemStack stack, @NotNull Item.TooltipContext context, @NotNull List<Component> tooltipComponents, @NotNull TooltipFlag tooltipFlag) {
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
        List<ArkaniaCard> cards = ArkaniaDeckItem.getCards(stack);
        if (!cards.isEmpty()) {
            tooltipComponents.add((Component)Component.literal((String)(cards.size() == 1 ? "1/30 Carta" : cards.size() + "/30 Cartas")).withStyle(new ChatFormatting[]{ChatFormatting.DARK_PURPLE, ChatFormatting.ITALIC}));
            List<Pair<List<Component>, Boolean>> verify = ArkaniaDeck.verifyDeck(cards);
            if (verify.isEmpty()) {
                tooltipComponents.add((Component)Component.literal((String)"Deck V\u00e1lido").withStyle(ChatFormatting.GREEN));
            } else if (verify.stream().noneMatch(Pair::getSecond)) {
                tooltipComponents.add((Component)Component.literal((String)"Deck V\u00e1lido (N\u00e3o recomendado)").withStyle(ChatFormatting.YELLOW));
            } else {
                tooltipComponents.add((Component)Component.literal((String)"Deck Inv\u00e1lido").withStyle(ChatFormatting.RED));
            }
        }
    }

    public static List<ArkaniaCard> getCards(ItemStack stack) {
        CustomData data = (CustomData)stack.get(ModDataComponentTypes.ARKANIA_DECK);
        CompoundTag nbt = data != null ? data.copyTag() : new CompoundTag();
        ListTag cards = nbt.getList("ArkanyamonDeck", 8);
        return cards.stream().map(Tag::getAsString).map(ArkaniaCard::load).filter(Objects::nonNull).filter(card -> card != ArkaniaCard.BLANK).map(ArkaniaCard::copy).toList();
    }

    public static ItemStack[] getDeckItems(ItemStack stack) {
        CustomData data = (CustomData)stack.get(ModDataComponentTypes.ARKANIA_DECK);
        CompoundTag nbt = data != null ? data.copyTag() : new CompoundTag();
        ListTag cards = nbt.getList("ArkanyamonDeck", 8);
        ItemStack[] items = new ItemStack[30];
        for (int i = 0; i < 30; ++i) {
            if (i < cards.size()) {
                ArkaniaCard card = ArkaniaCard.load(cards.get(i).getAsString());
                if (card != null && card != ArkaniaCard.BLANK) {
                    items[i] = ArkaniaCardItem.getCard(card);
                    continue;
                }
                items[i] = ItemStack.EMPTY;
                continue;
            }
            items[i] = ItemStack.EMPTY;
        }
        return items;
    }
}

