/*
 * Decompiled with CFR 0.152.
 */
package br.com.arkanis.arkanyamon.item;

import br.com.arkanis.arkanyamon.Arkanyamon;
import br.com.arkanis.arkanyamon.RevealedData;
import br.com.arkanis.arkanyamon.game.ArkaniaCard;
import br.com.arkanis.arkanyamon.game.ArkaniaElement;
import br.com.arkanis.arkanyamon.item.ModDataComponentTypes;
import br.com.arkanis.arkanyamon.item.ModItems;
import br.com.arkanis.arkanyamon.network.RevealedDataPayload;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.protocol.game.ClientboundSoundPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ArkaniaCardItem
extends Item {
    public ArkaniaCardItem(Item.Properties properties) {
        super(properties);
    }

    public void inventoryTick(@NotNull ItemStack stack, @NotNull Level level, @NotNull Entity entity, int slotId, boolean isSelected) {
        ArkaniaCard card = ArkaniaCardItem.getCard(stack);
        if (card != null && entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            RevealedData data = RevealedData.get(player.server);
            if (data.revealCard((Player)player, card)) {
                PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new RevealedDataPayload(data), (CustomPacketPayload[])new CustomPacketPayload[0]);
                player.displayClientMessage((Component)Component.literal((String)"Voc\u00ea descobriu a carta ").withStyle(ChatFormatting.GOLD).append(card.getName()), false);
                player.connection.send((Packet)new ClientboundSoundPacket((Holder)SoundEvents.NOTE_BLOCK_CHIME, SoundSource.NEUTRAL, player.getX(), player.getY(), player.getZ(), 1.0f, 1.0f, 0L));
            }
        }
    }

    public void appendHoverText(@NotNull ItemStack stack, @NotNull Item.TooltipContext context, @NotNull List<Component> tooltipComponents, @NotNull TooltipFlag tooltipFlag) {
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
        ArkaniaCard card = ArkaniaCardItem.getCard(stack);
        if (!Arkanyamon.isCardRevealed(card)) {
            tooltipComponents.add((Component)Component.literal((String)"Voc\u00ea ainda n\u00e3o descobriu essa carta").withStyle(ChatFormatting.RED));
        } else if (!Arkanyamon.isShiftDown() && card != null) {
            tooltipComponents.add(card.getDescriptor(0));
            tooltipComponents.add((Component)Component.literal((String)"Pressione SHIFT para visualizar").withStyle(ChatFormatting.GRAY));
        }
    }

    @NotNull
    public Optional<TooltipComponent> getTooltipImage(@NotNull ItemStack stack) {
        return Arkanyamon.isShiftDown() ? (Arkanyamon.isCardRevealed(ArkaniaCardItem.getCard(stack)) ? Optional.ofNullable(ArkaniaCardItem.getCard(stack)) : Optional.empty()) : Optional.empty();
    }

    @NotNull
    public Component getName(@NotNull ItemStack stack) {
        ArkaniaCard card = ArkaniaCardItem.getCard(stack);
        if (!Arkanyamon.isCardRevealed(card)) {
            return Component.literal((String)"????");
        }
        if (Arkanyamon.isShiftDown()) {
            return Component.empty();
        }
        if (card != null) {
            ArkaniaElement element = card.element();
            MutableComponent name = Component.empty().append(card.getName());
            if (element != null) {
                return name.append(" ").append(element.getIcon());
            }
            return name;
        }
        return super.getName(stack);
    }

    @Nullable
    public static ArkaniaCard getCard(ItemStack stack) {
        String card = (String)stack.get(ModDataComponentTypes.ARKANIA_CARD);
        return card != null ? ArkaniaCard.load(card) : null;
    }

    public static ItemStack getCard(ArkaniaCard card) {
        ItemStack stack = ((ArkaniaCardItem)((Object)ModItems.CARD.get())).getDefaultInstance();
        stack.set(ModDataComponentTypes.ARKANIA_CARD, (Object)card.name());
        return stack;
    }
}

