/*
 * Decompiled with CFR 0.152.
 */
package br.com.arkanis.arkanyamon.game.actions;

import br.com.arkanis.arkanyamon.game.ArkaniaCard;
import br.com.arkanis.arkanyamon.game.ArkaniaElement;
import br.com.arkanis.arkanyamon.game.ArkaniaGame;
import br.com.arkanis.arkanyamon.game.TransmutableCard;
import br.com.arkanis.arkanyamon.game.actions.Action;
import dev.lucaargolo.charta.game.CardPlayer;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.Nullable;

public record TransmuteAction(int energy) implements Action
{
    @Override
    public Action.Choose getChooseAction() {
        return Action.Choose.ACTIVE_ONLY;
    }

    @Override
    public boolean isAttackAction() {
        return false;
    }

    @Override
    public boolean canExecute(ArkaniaCard card, CardPlayer player, ArkaniaGame game, @Nullable ArkaniaCard target) {
        return card instanceof TransmutableCard && card.getEnergy() >= this.energy;
    }

    @Override
    public boolean execute(ArkaniaCard card, CardPlayer player, ArkaniaGame game, @Nullable ArkaniaCard target) {
        game.getActiveCard(game.getOpponent(player)).ifPresent(enemy -> {
            ArkaniaElement element = enemy.element();
            if (element != null && card instanceof TransmutableCard) {
                TransmutableCard transmutable = (TransmutableCard)card;
                Component name = card.getName();
                transmutable.setElement(element);
                if (transmutable.getElement() == element) {
                    game.play(player, (Component)Component.empty().append(name).append(" transmutou para ").append(element.getName()).append(" ").append(element.getIcon()));
                }
            }
        });
        return true;
    }

    @Override
    public Component getName(ArkaniaCard card) {
        return Component.empty();
    }
}

