/*
 * Decompiled with CFR 0.152.
 */
package br.com.arkanis.arkanyamon.game.actions;

import br.com.arkanis.arkanyamon.game.ArkaniaCard;
import br.com.arkanis.arkanyamon.game.ArkaniaGame;
import br.com.arkanis.arkanyamon.game.actions.Action;
import br.com.arkanis.arkanyamon.game.actions.AttackAction;
import dev.lucaargolo.charta.game.CardPlayer;
import dev.lucaargolo.charta.game.GameSlot;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.Nullable;

public record NukeAction() implements Action
{
    @Override
    public Action.Choose getChooseAction() {
        return Action.Choose.ACTIVE_ONLY;
    }

    @Override
    public boolean isAttackAction() {
        return true;
    }

    @Override
    public boolean canExecute(ArkaniaCard card, CardPlayer player, ArkaniaGame game, @Nullable ArkaniaCard target) {
        return card.getEnergy() >= 4;
    }

    @Override
    public boolean execute(ArkaniaCard card, CardPlayer player, ArkaniaGame game, @Nullable ArkaniaCard target) {
        CardPlayer opponent = game.getOpponent(player);
        GameSlot hand = game.getPlayerHand(opponent);
        AttackAction attack = new AttackAction((Component)Component.literal((String)"Nuke"), false, 10, 0);
        hand.forEach(c -> {
            if (c instanceof ArkaniaCard) {
                ArkaniaCard enemy = (ArkaniaCard)((Object)c);
                attack.execute(card, player, game, enemy);
            }
        });
        return true;
    }

    @Override
    public Component getName(ArkaniaCard card) {
        return Component.empty();
    }
}

