/*
 * Decompiled with CFR 0.152.
 */
package br.com.arkanis.arkanyamon.game.actions;

import br.com.arkanis.arkanyamon.game.ArkaniaCard;
import br.com.arkanis.arkanyamon.game.ArkaniaElement;
import br.com.arkanis.arkanyamon.game.ArkaniaGame;
import br.com.arkanis.arkanyamon.game.actions.Action;
import dev.lucaargolo.charta.game.CardPlayer;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.Nullable;

public record HealElementAction(Component name, int amount, ArkaniaElement element) implements Action
{
    @Override
    public Action.Choose getChooseAction() {
        return Action.Choose.ACTIVE_ONLY;
    }

    @Override
    public boolean isAttackAction() {
        return false;
    }

    @Override
    public boolean canExecute(ArkaniaCard card, CardPlayer player, ArkaniaGame game, @Nullable ArkaniaCard target) {
        return game.getActiveCard(player).map(c -> c.isSpecialist() && c.element() == this.element && c.getHealth() < c.getMaxHealth()).orElse(false);
    }

    @Override
    public boolean execute(ArkaniaCard card, CardPlayer player, ArkaniaGame game, @Nullable ArkaniaCard target) {
        game.getActiveCard(player).ifPresent(active -> {
            int h = Math.min(this.amount, active.getMaxHealth() - card.getHealth());
            game.play(player, (Component)Component.empty().append(card.getName()).append(" curou ").append((Component)Component.literal((String)(h + " de vida")).withStyle(ChatFormatting.GREEN)).append(" de ").append(active.getName()));
            active.setHealth(active.getHealth() + h);
        });
        return true;
    }

    @Override
    public Component getName(ArkaniaCard card) {
        return this.name.copy().withStyle(card.getName().getStyle());
    }
}

