/*
 * Decompiled with CFR 0.152.
 */
package br.com.arkanis.arkanyamon.game.actions;

import br.com.arkanis.arkanyamon.game.ArkaniaCard;
import br.com.arkanis.arkanyamon.game.ArkaniaGame;
import br.com.arkanis.arkanyamon.game.actions.Action;
import dev.lucaargolo.charta.game.CardPlayer;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.Nullable;

public record HealAction(Component name, boolean choose, int amount) implements Action
{
    @Override
    public Action.Choose getChooseAction() {
        return this.choose ? Action.Choose.CHOOSE_FRIENDLY : Action.Choose.ACTIVE_ONLY;
    }

    @Override
    public boolean isAttackAction() {
        return false;
    }

    @Override
    public boolean canExecute(ArkaniaCard card, CardPlayer player, ArkaniaGame game, @Nullable ArkaniaCard target) {
        if (target == null) {
            return game.getActiveCard(player).map(c -> c.isSpecialist() && c.getHealth() < c.getMaxHealth()).orElse(false);
        }
        return target.getHealth() < target.getMaxHealth();
    }

    @Override
    public boolean execute(ArkaniaCard card, CardPlayer player, ArkaniaGame game, @Nullable ArkaniaCard target) {
        if (target == null) {
            game.getActiveCard(player).ifPresent(t -> this.execute(card, player, game, (ArkaniaCard)((Object)t)));
        } else if (target.isSpecialist()) {
            int h = Math.min(this.amount, target.getMaxHealth() - card.getHealth());
            if (card == target) {
                game.play(player, (Component)Component.empty().append(card.getName()).append(" curou ").append((Component)Component.literal((String)(h + " de vida")).withStyle(ChatFormatting.GREEN)));
            } else {
                game.play(player, (Component)Component.empty().append(card.getName()).append(" curou ").append((Component)Component.literal((String)(h + " de vida")).withStyle(ChatFormatting.GREEN)).append(" de ").append(target.getName()));
            }
            target.setHealth(target.getHealth() + h);
        }
        return true;
    }

    @Override
    public Component getName(ArkaniaCard card) {
        return this.name.copy().withStyle(card.getName().getStyle());
    }
}

