/*
 * Decompiled with CFR 0.152.
 */
package br.com.arkanis.arkanyamon.game.actions;

import br.com.arkanis.arkanyamon.game.ArkaniaCard;
import br.com.arkanis.arkanyamon.game.ArkaniaGame;
import br.com.arkanis.arkanyamon.game.Effect;
import br.com.arkanis.arkanyamon.game.actions.Action;
import dev.lucaargolo.charta.game.CardPlayer;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.Nullable;

public record EffectAction(Component name, Action.Choose choose, Effect effect) implements Action
{
    @Override
    public Action.Choose getChooseAction() {
        return this.choose;
    }

    @Override
    public boolean isAttackAction() {
        return false;
    }

    @Override
    public boolean canExecute(ArkaniaCard card, CardPlayer player, ArkaniaGame game, @Nullable ArkaniaCard target) {
        return true;
    }

    @Override
    public boolean execute(ArkaniaCard card, CardPlayer player, ArkaniaGame game, @Nullable ArkaniaCard target) {
        if (target == null) {
            CardPlayer affectedPlayer = this.effect.isPositive() ? player : game.getOpponent(player);
            game.getActiveCard(affectedPlayer).ifPresent(t -> this.execute(card, player, game, (ArkaniaCard)((Object)t)));
        } else if (target.isSpecialist()) {
            if (card == target) {
                game.play(player, (Component)Component.empty().append(card.getName()).append(" aplicou ").append(this.effect.getName()));
            } else {
                game.play(player, (Component)Component.empty().append(card.getName()).append(" aplicou ").append(this.effect.getName()).append(" em ").append(target.getName()));
            }
            target.setEffect(this.effect);
        }
        return true;
    }

    @Override
    public Component getName(ArkaniaCard card) {
        return this.name.copy().withStyle(card.getName().getStyle());
    }
}

