/*
 * Decompiled with CFR 0.152.
 */
package br.com.arkanis.arkanyamon.game.actions;

import br.com.arkanis.arkanyamon.game.ArkaniaCard;
import br.com.arkanis.arkanyamon.game.ArkaniaGame;
import br.com.arkanis.arkanyamon.game.actions.Action;
import dev.lucaargolo.charta.game.CardPlayer;
import dev.lucaargolo.charta.game.GameSlot;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.Nullable;

public record DestroyCardsAction(Component name, int amount) implements Action
{
    @Override
    public boolean isAttackAction() {
        return false;
    }

    @Override
    public Action.Choose getChooseAction() {
        return Action.Choose.ACTIVE_ONLY;
    }

    @Override
    public boolean canExecute(ArkaniaCard card, CardPlayer player, ArkaniaGame game, @Nullable ArkaniaCard target) {
        return true;
    }

    @Override
    public boolean execute(ArkaniaCard card, CardPlayer player, ArkaniaGame game, @Nullable ArkaniaCard target) {
        CardPlayer opponent = game.getOpponent(player);
        GameSlot hand = game.getPlayerHand(opponent);
        if (hand.size() >= this.amount) {
            for (int i = 0; i < this.amount; ++i) {
                hand.removeLast();
            }
            game.play(player, (Component)Component.literal((String)(this.amount + " cartas foram removidas do baralho de ")).append(opponent.getName()));
        }
        return true;
    }

    @Override
    public Component getName(ArkaniaCard card) {
        return this.name.copy().withStyle(card.getName().getStyle());
    }
}

