/*
 * Decompiled with CFR 0.152.
 */
package br.com.arkanis.arkanyamon.game.actions;

import br.com.arkanis.arkanyamon.game.ArkaniaCard;
import br.com.arkanis.arkanyamon.game.ArkaniaElement;
import br.com.arkanis.arkanyamon.game.ArkaniaGame;
import br.com.arkanis.arkanyamon.game.actions.Action;
import dev.lucaargolo.charta.game.Card;
import dev.lucaargolo.charta.game.CardPlayer;
import dev.lucaargolo.charta.game.GameSlot;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.Nullable;

public record ConsumeEnergyInBenchAction(int energy) implements Action
{
    @Override
    public Action.Choose getChooseAction() {
        return Action.Choose.ACTIVE_ONLY;
    }

    @Override
    public boolean isAttackAction() {
        return false;
    }

    @Override
    public boolean canExecute(ArkaniaCard card, CardPlayer player, ArkaniaGame game, @Nullable ArkaniaCard target) {
        return card.getEnergy() >= this.energy;
    }

    @Override
    public boolean execute(ArkaniaCard card, CardPlayer player, ArkaniaGame game, @Nullable ArkaniaCard target) {
        GameSlot active = game.getActiveSlot(player);
        Card card2 = active.getLast();
        if (card2 instanceof ArkaniaCard) {
            ArkaniaCard affectedCard = (ArkaniaCard)card2;
            ArkaniaElement element = affectedCard.element();
            if (affectedCard != card && element != null && card.isSpecialist()) {
                game.play(player, (Component)Component.empty().append(card.getName()).append(" gastou " + this.energy + " de energia"));
                card.setEnergy(Math.max(0, card.getEnergy() - this.energy));
                GameSlot deck = game.getDeckSlot(player);
                ArkaniaCard ghost = element.getCard().copy();
                ghost.flip();
                for (int i = 0; i < this.energy; ++i) {
                    deck.add((Card)ghost.copy());
                }
                deck.shuffle();
            }
            return true;
        }
        return false;
    }

    @Override
    public Component getName(ArkaniaCard card) {
        return Component.empty();
    }
}

