/*
 * Decompiled with CFR 0.152.
 */
package br.com.arkanis.arkanyamon.game.actions;

import br.com.arkanis.arkanyamon.game.ArkaniaCard;
import br.com.arkanis.arkanyamon.game.ArkaniaElement;
import br.com.arkanis.arkanyamon.game.ArkaniaGame;
import br.com.arkanis.arkanyamon.game.actions.Action;
import dev.lucaargolo.charta.game.Card;
import dev.lucaargolo.charta.game.CardPlayer;
import dev.lucaargolo.charta.game.GameSlot;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.Nullable;

public record ConsumeEnergyAction(int energy) implements Action
{
    @Override
    public Action.Choose getChooseAction() {
        return Action.Choose.ACTIVE_ONLY;
    }

    @Override
    public boolean isAttackAction() {
        return false;
    }

    @Override
    public boolean canExecute(ArkaniaCard card, CardPlayer player, ArkaniaGame game, @Nullable ArkaniaCard target) {
        return card.getEnergy() >= this.energy;
    }

    @Override
    public boolean execute(ArkaniaCard card, CardPlayer player, ArkaniaGame game, @Nullable ArkaniaCard target) {
        if (card.isSpecialist()) {
            game.play(player, (Component)Component.empty().append(card.getName()).append(" gastou " + this.energy + " de energia"));
            card.setEnergy(Math.max(0, card.getEnergy() - this.energy));
            ArkaniaElement element = card.element();
            if (element != null) {
                ArkaniaCard ghost = element.getCard().copy();
                ghost.flip();
                GameSlot deck = game.getDeckSlot(player);
                for (int i = 0; i < this.energy; ++i) {
                    deck.add((Card)ghost.copy());
                }
                deck.shuffle();
            }
        }
        return true;
    }

    @Override
    public Component getName(ArkaniaCard card) {
        return Component.empty();
    }
}

