/*
 * Decompiled with CFR 0.152.
 */
package br.com.arkanis.arkanyamon.game.actions;

import br.com.arkanis.arkanyamon.game.ArkaniaCard;
import br.com.arkanis.arkanyamon.game.ArkaniaGame;
import br.com.arkanis.arkanyamon.game.actions.Action;
import dev.lucaargolo.charta.game.CardPlayer;
import java.util.function.Function;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.Nullable;

public record CombinedAction(Component name, Action.Choose choose, boolean attack, boolean bench, Function<Component, Action>[] actions) implements Action
{
    @Override
    public Action.Choose getChooseAction() {
        return this.choose;
    }

    @Override
    public boolean isAttackAction() {
        return this.attack;
    }

    @Override
    public boolean canExecuteInBench() {
        return this.bench;
    }

    @Override
    public boolean canExecute(ArkaniaCard card, CardPlayer player, ArkaniaGame game, @Nullable ArkaniaCard target) {
        for (Action action : this.getActions()) {
            if (action.canExecute(card, player, game, target)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean execute(ArkaniaCard card, CardPlayer player, ArkaniaGame game, @Nullable ArkaniaCard target) {
        for (Action action : this.getActions()) {
            if (action.execute(card, player, game, target)) continue;
            return false;
        }
        return true;
    }

    @Override
    public Component getName(ArkaniaCard card) {
        return this.name.copy().withStyle(card.getName().getStyle());
    }

    public Action[] getActions() {
        Action[] array = new Action[this.actions.length];
        for (int i = 0; i < this.actions.length; ++i) {
            array[i] = this.actions[i].apply(this.name);
        }
        return array;
    }
}

