/*
 * Decompiled with CFR 0.152.
 */
package br.com.arkanis.arkanyamon.game.actions;

import br.com.arkanis.arkanyamon.game.ArkaniaCard;
import br.com.arkanis.arkanyamon.game.ArkaniaGame;
import br.com.arkanis.arkanyamon.game.actions.Action;
import dev.lucaargolo.charta.game.CardPlayer;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.Nullable;

public record ChargeAction(Component name, boolean choose, int amount) implements Action
{
    @Override
    public Action.Choose getChooseAction() {
        return this.choose ? Action.Choose.CHOOSE_FRIENDLY : Action.Choose.ACTIVE_ONLY;
    }

    @Override
    public boolean isAttackAction() {
        return false;
    }

    @Override
    public boolean canExecute(ArkaniaCard card, CardPlayer player, ArkaniaGame game, @Nullable ArkaniaCard target) {
        if (target == null) {
            return game.getActiveCard(player).map(ArkaniaCard::isSpecialist).orElse(false);
        }
        return true;
    }

    @Override
    public boolean execute(ArkaniaCard card, CardPlayer player, ArkaniaGame game, @Nullable ArkaniaCard target) {
        if (target == null) {
            game.getActiveCard(player).ifPresent(t -> this.execute(card, player, game, (ArkaniaCard)((Object)t)));
        } else if (target.isSpecialist()) {
            if (card == target) {
                game.play(player, (Component)Component.empty().append(card.getName()).append(" adicionou ").append((Component)Component.literal((String)(this.amount + " de energia")).withStyle(ChatFormatting.GREEN)));
            } else {
                game.play(player, (Component)Component.empty().append(card.getName()).append(" adicionou ").append((Component)Component.literal((String)(this.amount + " de energia")).withStyle(ChatFormatting.GREEN)).append(" em ").append(target.getName()));
            }
            target.setEnergy(target.getEnergy() + this.amount);
        }
        return true;
    }

    @Override
    public Component getName(ArkaniaCard card) {
        return this.name.copy().withStyle(card.getName().getStyle());
    }
}

