/*
 * Decompiled with CFR 0.152.
 */
package br.com.arkanis.arkanyamon.game.actions;

import br.com.arkanis.arkanyamon.game.ArkaniaCard;
import br.com.arkanis.arkanyamon.game.ArkaniaElement;
import br.com.arkanis.arkanyamon.game.ArkaniaGame;
import br.com.arkanis.arkanyamon.game.Effect;
import br.com.arkanis.arkanyamon.game.actions.Action;
import br.com.arkanis.arkanyamon.sound.ModSounds;
import dev.lucaargolo.charta.game.CardPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.sounds.SoundEvent;
import org.jetbrains.annotations.Nullable;

public record AttackAction(Component name, boolean choose, int damage, int energy) implements Action
{
    @Override
    public Action.Choose getChooseAction() {
        return this.choose ? Action.Choose.CHOOSE_ENEMY : Action.Choose.ACTIVE_ONLY;
    }

    @Override
    public boolean isAttackAction() {
        return true;
    }

    @Override
    public boolean canExecute(ArkaniaCard card, CardPlayer player, ArkaniaGame game, @Nullable ArkaniaCard target) {
        return card.getEnergy() >= this.energy;
    }

    @Override
    public boolean execute(ArkaniaCard card, CardPlayer player, ArkaniaGame game, @Nullable ArkaniaCard target) {
        if (target == null) {
            game.getActiveCard(game.getOpponent(player)).ifPresent(t -> this.execute(card, player, game, (ArkaniaCard)((Object)t)));
        } else if (target.isSpecialist()) {
            int d = this.damage;
            MutableComponent message = Component.empty();
            message = message.append(card.getName());
            message = message.append(" deu ");
            ArkaniaElement element = card.element();
            if (element != null) {
                message = message.append((Component)Component.literal((String)(d + " de dano ")).withStyle(element.getName().getStyle()));
                message = message.append(element.getName()).append(" ").append(element.getIcon());
            } else {
                message = message.append(d + " de dano ");
            }
            message = message.append(" em ");
            message = message.append(target.getName());
            game.play(player, (Component)message);
            Effect effect = card.getEffect();
            if (effect == Effect.POUCO_FORTE) {
                d += 10;
                game.play(player, (Component)Component.empty().append(card.getName()).append(" deu ").append((Component)Component.literal((String)"10 de dano extra").withStyle(effect.getName().getStyle().withItalic(Boolean.valueOf(true)))).append(" em ").append(target.getName()).append(" por estar ").append(effect.getName()));
            } else if (effect == Effect.FORTE) {
                d += 20;
                game.play(player, (Component)Component.empty().append(card.getName()).append(" deu ").append((Component)Component.literal((String)"20 de dano extra").withStyle(effect.getName().getStyle().withItalic(Boolean.valueOf(true)))).append(" em ").append(target.getName()).append(" por estar ").append(effect.getName()));
            } else if (effect == Effect.MUITO_FORTE) {
                d += 30;
                game.play(player, (Component)Component.empty().append(card.getName()).append(" deu ").append((Component)Component.literal((String)"30 de dano extra").withStyle(effect.getName().getStyle().withItalic(Boolean.valueOf(true)))).append(" em ").append(target.getName()).append(" por estar ").append(effect.getName()));
            } else if (effect == Effect.MULHER && target.isMale()) {
                d += 20;
                game.play(player, (Component)Component.empty().append(card.getName()).append(" deu ").append((Component)Component.literal((String)"20 de dano extra").withStyle(effect.getName().getStyle().withItalic(Boolean.valueOf(true)))).append(" em ").append(target.getName()).append(" por ele ser homem"));
            }
            if (target.getEffect() == Effect.CHAMAS) {
                d += 20;
                game.play(player, (Component)Component.empty().append(target.getName()).append(" levou ").append((Component)Component.literal((String)"20 de dano extra").withStyle(Effect.CHAMAS.getName().getStyle())).append(" por estar em chamas"));
            }
            if (element != null && element == target.weakness()) {
                d += 20;
                game.play(player, (Component)Component.empty().append(target.getName()).append(" levou ").append((Component)Component.literal((String)"20 de dano extra").withStyle(element.getName().getStyle())).append(" devido a sua fraqueza contra o elemento ").append(element.getName()).append(" ").append(element.getIcon()));
            }
            target.setHealth(Math.max(target.getHealth() - d, 0));
            player.playSound((SoundEvent)ModSounds.ATTACK.get());
        }
        return true;
    }

    @Override
    public Component getName(ArkaniaCard card) {
        return this.name.copy().withStyle(card.getName().getStyle());
    }
}

