/*
 * Decompiled with CFR 0.152.
 */
package br.com.arkanis.arkanyamon.game.actions;

import br.com.arkanis.arkanyamon.game.ArkaniaCard;
import br.com.arkanis.arkanyamon.game.ArkaniaGame;
import br.com.arkanis.arkanyamon.game.actions.Action;
import br.com.arkanis.arkanyamon.network.ActivatePayload;
import dev.lucaargolo.charta.game.CardPlayer;
import java.util.List;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.Nullable;

public record ActivateCardAction(Component name, ArkaniaCard card) implements Action
{
    @Override
    public Action.Choose getChooseAction() {
        return Action.Choose.ACTIVE_ONLY;
    }

    @Override
    public boolean isAttackAction() {
        return false;
    }

    @Override
    public boolean canExecute(ArkaniaCard card, CardPlayer player, ArkaniaGame game, @Nullable ArkaniaCard target) {
        return game.getPlayerHand(player).stream().anyMatch(c -> {
            ArkaniaCard a;
            return c instanceof ArkaniaCard && (a = (ArkaniaCard)((Object)c)).rank() == this.card.rank();
        });
    }

    @Override
    public boolean execute(ArkaniaCard card, CardPlayer player, ArkaniaGame game, @Nullable ArkaniaCard target) {
        List<ArkaniaCard> hand = game.getPlayerHand(player).stream().filter(c -> c instanceof ArkaniaCard).map(c -> (ArkaniaCard)((Object)c)).toList();
        hand.stream().filter(c -> c.rank() == this.card.rank()).findAny().ifPresent(equip -> ActivatePayload.activateCard(game, player, hand.indexOf(equip)));
        return true;
    }

    @Override
    public Component getName(ArkaniaCard card) {
        return this.name.copy().withStyle(card.getName().getStyle());
    }
}

