/*
 * Decompiled with CFR 0.152.
 */
package br.com.arkanis.arkanyamon.game;

import br.com.arkanis.arkanyamon.Arkanyamon;
import br.com.arkanis.arkanyamon.game.ArkaniaCard;
import br.com.arkanis.arkanyamon.game.ArkaniaDeck;
import br.com.arkanis.arkanyamon.game.ArkaniaElement;
import br.com.arkanis.arkanyamon.game.Effect;
import br.com.arkanis.arkanyamon.game.actions.Action;
import com.mojang.datafixers.util.Pair;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;

public class TransmutableCard
extends ArkaniaCard {
    private final Map<ArkaniaElement, TransmutableCard> transmutations;
    private ArkaniaElement currentElement;

    public TransmutableCard(String name, int health, boolean male, int energyRequiredToRetreat, ArkaniaCard.Type type, List<Pair<ArkaniaElement, ArkaniaElement>> elementConfigs, Action ... actions) {
        super(name, health, male, energyRequiredToRetreat, type, (ArkaniaElement)((Object)elementConfigs.get(0).getFirst()), (ArkaniaElement)((Object)elementConfigs.get(0).getSecond()), actions);
        this.transmutations = new HashMap<ArkaniaElement, TransmutableCard>();
        this.transmutations.put((ArkaniaElement)((Object)elementConfigs.get(0).getFirst()), this);
        for (int i = 1; i < elementConfigs.size(); ++i) {
            Pair<ArkaniaElement, ArkaniaElement> pair = elementConfigs.get(i);
            ArkaniaElement element = (ArkaniaElement)((Object)pair.getFirst());
            ArkaniaElement weakness = (ArkaniaElement)((Object)pair.getSecond());
            this.transmutations.put(element, new TransmutableCard(this, name, health, male, energyRequiredToRetreat, type, element, weakness, actions));
        }
        this.currentElement = (ArkaniaElement)((Object)elementConfigs.get(0).getFirst());
    }

    protected TransmutableCard(TransmutableCard original, String name, int health, boolean male, int energyRequiredToRetreat, ArkaniaCard.Type type, ArkaniaElement element, ArkaniaElement weakness, Action ... actions) {
        super(name + "_" + element.name(), health, male, energyRequiredToRetreat, type, element, weakness, actions);
        this.original = original;
        this.transmutations = original.transmutations;
        this.currentElement = element;
        this.texture = type != null ? Arkanyamon.id("textures/card/" + type.name + "/" + name + "/" + element.name() + ".png") : ArkaniaDeck.IMAGE;
    }

    private TransmutableCard(TransmutableCard original) {
        super(original);
        this.element = this.currentElement = original.element();
        this.weakness = original.weakness();
        this.transmutations = original.transmutations;
    }

    public Map<ArkaniaElement, TransmutableCard> getTransmutations() {
        return this.transmutations;
    }

    public ArkaniaElement getElement() {
        return this.currentElement;
    }

    public void setElement(ArkaniaElement element) {
        this.currentElement = this.transmutations.containsKey((Object)element) ? element : this.element;
    }

    @Override
    public boolean equals(Object o) {
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TransmutableCard that = (TransmutableCard)((Object)o);
        return Objects.equals((Object)this.currentElement, (Object)that.currentElement);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.currentElement});
    }

    @Override
    public TransmutableCard copy() {
        return new TransmutableCard(this);
    }

    @Override
    public Component getName() {
        return Component.translatable((String)("card.arkanyamon." + (this.original != null ? this.original.name : this.name))).withStyle(s -> s.withColor(this.currentElement != null ? this.currentElement.lightColor() : 0xFFFFFF));
    }

    @Override
    @Nullable
    public ArkaniaElement element() {
        return this.transmutations.get((Object)this.currentElement) != null && this.transmutations.get((Object)this.currentElement) != this ? this.transmutations.get((Object)this.currentElement).element() : this.element;
    }

    @Override
    @Nullable
    public ArkaniaElement weakness() {
        return this.transmutations.get((Object)this.currentElement) != null && this.transmutations.get((Object)this.currentElement) != this ? this.transmutations.get((Object)this.currentElement).weakness() : this.weakness;
    }

    @Override
    public ResourceLocation texture() {
        ResourceLocation texture = this.transmutations.get((Object)this.currentElement) != null && this.transmutations.get((Object)this.currentElement) != this ? this.transmutations.get((Object)this.currentElement).texture() : this.texture;
        return this.effect == Effect.CALVO ? texture.withPath(p -> p.replace(".png", "_careca.png")) : texture;
    }
}

