/*
 * Decompiled with CFR 0.152.
 */
package br.com.arkanis.arkanyamon.game;

import br.com.arkanis.arkanyamon.game.ArkaniaCard;
import br.com.arkanis.arkanyamon.game.ArkaniaDeck;
import br.com.arkanis.arkanyamon.game.Effect;
import br.com.arkanis.arkanyamon.item.ArkaniaDeckItem;
import br.com.arkanis.arkanyamon.menu.ArkaniaGameMenu;
import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import dev.lucaargolo.charta.game.AutoPlayer;
import dev.lucaargolo.charta.game.Card;
import dev.lucaargolo.charta.game.CardGame;
import dev.lucaargolo.charta.game.CardPlay;
import dev.lucaargolo.charta.game.CardPlayer;
import dev.lucaargolo.charta.game.Deck;
import dev.lucaargolo.charta.game.GameOption;
import dev.lucaargolo.charta.game.GameSlot;
import dev.lucaargolo.charta.menu.AbstractCardMenu;
import dev.lucaargolo.charta.network.CardPlayPayload;
import dev.lucaargolo.charta.sound.ModSounds;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.network.PacketDistributor;

public class ArkaniaGame
extends CardGame<ArkaniaGame> {
    private final GameOption.Number REQUIRED_WINS = new GameOption.Number(3, 1, 6, (Component)Component.literal((String)"Vitorias necessarias"), (Component)Component.literal((String)"Quantas vezes voc\u00ea deve derrotar a carta do oponente para ganhar a partida"));
    private final List<List<ArkaniaCard>> playerDecks;
    private int round = 0;
    private final CardPlayer firstPlayer;
    private final CardPlayer secondPlayer;
    private final int[] victories = new int[2];
    private final List<GameSlot> activeSlots;
    private final List<GameSlot> deckSlots;
    private boolean usedEnergy = false;
    private boolean usedAbility = false;
    private boolean usedItem = false;

    public ArkaniaGame(List<CardPlayer> players, Deck ignored) {
        super(players, (Deck)ArkaniaDeck.INSTANCE);
        ArrayList<CardPlayer> shuffledPlayers = new ArrayList<CardPlayer>(players);
        Collections.shuffle(shuffledPlayers);
        this.firstPlayer = (CardPlayer)shuffledPlayers.stream().findFirst().orElse(new AutoPlayer(0.0f));
        this.secondPlayer = shuffledPlayers.stream().filter(p -> p != this.firstPlayer).findFirst().orElse((CardPlayer)new AutoPlayer(0.0f));
        float middleX = 80.0f;
        float middleY = 80.0f;
        this.playerDecks = List.of(Objects.requireNonNull(ArkaniaGame.getDeckCards(this.firstPlayer.getEntity())), Objects.requireNonNull(ArkaniaGame.getDeckCards(this.secondPlayer.getEntity())));
        Function<CardPlayer, GameSlot> activeSlotSupplier = owner -> new GameSlot(this, new LinkedList(), owner == this.firstPlayer ? middleX - 12.5f : middleX + 12.5f, owner == this.firstPlayer ? middleY - 10.0f - 35.0f : middleY + 10.0f + 35.0f, 0.0f, owner == this.firstPlayer ? 0.0f : 180.0f){

            public boolean canInsertCard(CardPlayer player, List<Card> cards, int index) {
                return false;
            }

            public boolean canRemoveCard(CardPlayer player, int index) {
                return false;
            }
        };
        Function<CardPlayer, GameSlot> deckSlotSupplier = owner -> new GameSlot(this, new LinkedList(this.playerDecks.get(owner == this.firstPlayer ? 0 : 1)), owner == this.firstPlayer ? middleX + 90.0f : middleX - 90.0f, owner == this.firstPlayer ? middleY - 90.0f - 35.0f : middleY + 90.0f + 35.0f, 0.0f, owner == this.firstPlayer ? 0.0f : 180.0f){

            public boolean canInsertCard(CardPlayer player, List<Card> cards, int index) {
                return false;
            }

            public boolean canRemoveCard(CardPlayer player, int index) {
                return false;
            }
        };
        this.activeSlots = List.of(this.addSlot(activeSlotSupplier.apply(this.firstPlayer)), this.addSlot(activeSlotSupplier.apply(this.secondPlayer)));
        this.deckSlots = List.of(this.addSlot(deckSlotSupplier.apply(this.firstPlayer)), this.addSlot(deckSlotSupplier.apply(this.secondPlayer)));
    }

    public static boolean areDeckCardsValid(List<ArkaniaCard> cards) {
        return ArkaniaDeck.verifyDeck(cards).stream().noneMatch(Pair::getSecond);
    }

    public static List<ArkaniaCard> getDeckCards(LivingEntity entity) {
        if (entity != null) {
            for (InteractionHand hand : InteractionHand.values()) {
                ItemStack stack = entity.getItemInHand(hand);
                if (!(stack.getItem() instanceof ArkaniaDeckItem)) continue;
                return ArkaniaDeckItem.getCards(stack);
            }
        }
        return List.of();
    }

    public AbstractCardMenu<ArkaniaGame> createMenu(int i, Inventory inventory, ServerLevel serverLevel, BlockPos blockPos, Deck deck) {
        return new ArkaniaGameMenu(i, inventory, ContainerLevelAccess.create((Level)serverLevel, (BlockPos)blockPos), (ArkaniaDeck)deck, this.players.stream().mapToInt(CardPlayer::getId).toArray(), this.getRawOptions());
    }

    public Predicate<Deck> getDeckPredicate() {
        return deck -> deck == ArkaniaDeck.INSTANCE;
    }

    public Predicate<Card> getCardPredicate() {
        return card -> true;
    }

    public Either<CardGame<?>, Component> playerPredicate(List<CardPlayer> players) {
        for (CardPlayer player : players) {
            LivingEntity entity = player.getEntity();
            if (entity instanceof LivingEntity) {
                LivingEntity living = entity;
                List<ArkaniaCard> cards = ArkaniaGame.getDeckCards(living);
                if (ArkaniaGame.areDeckCardsValid(cards)) continue;
                return Either.right((Object)Component.translatable((String)"message.arkanyamon.invalid_deck_cards"));
            }
            return Either.right((Object)Component.translatable((String)"message.arkanyamon.invalid_deck_cards"));
        }
        return Either.left((Object)((Object)this));
    }

    public boolean canPlay(CardPlayer cardPlayer, CardPlay cardPlay) {
        return false;
    }

    public void startGame() {
        this.currentPlayer = this.firstPlayer;
        this.isGameReady = false;
        this.isGameOver = false;
        this.deckSlots.get(0).addAll(this.activeSlots.get(0));
        this.deckSlots.get(1).addAll(this.activeSlots.get(1));
        this.deckSlots.forEach(slot -> {
            slot.forEach(card -> {
                if (!card.flipped()) {
                    card.flip();
                }
            });
            slot.shuffle();
        });
        for (CardPlayer player : this.players) {
            ArkaniaCard card;
            int i;
            player.resetPlay();
            this.getPlayerHand(player).clear();
            this.getCensoredHand(player).clear();
            GameSlot deckSlot = this.deckSlots.get(player == this.firstPlayer ? 0 : 1);
            ArrayList<ArkaniaCard> firstCards = new ArrayList<ArkaniaCard>();
            while (firstCards.stream().filter(c -> c.type() == ArkaniaCard.Type.SPECIALIST).findAny().isEmpty()) {
                deckSlot.shuffle();
                firstCards.clear();
                for (i = 1; i <= 5; ++i) {
                    card = (ArkaniaCard)deckSlot.get(deckSlot.size() - i);
                    firstCards.add(card);
                }
            }
            for (i = 1; i <= 5; ++i) {
                card = (ArkaniaCard)deckSlot.removeLast();
                card.flip();
                this.scheduledActions.add(() -> {
                    this.currentPlayer.playSound((SoundEvent)ModSounds.CARD_DRAW.get());
                    this.getPlayerHand(player).add((Card)card);
                    this.getCensoredHand(player).add((Card)card);
                });
            }
        }
    }

    public void runGame() {
        if (!this.isGameReady) {
            return;
        }
        this.currentPlayer.afterPlay(play -> {
            this.currentPlayer.resetPlay();
            if (play == null) {
                this.nextPlayerAndRunGame();
            } else {
                Object patt0$temp;
                if (play.cards().isEmpty() || !((patt0$temp = play.cards().get(0)) instanceof ArkaniaCard)) {
                    this.endGame();
                    return;
                }
                ArkaniaCard card = (ArkaniaCard)((Object)((Object)patt0$temp));
                int index = play.slot();
                if (index > -1 && index < card.actions().length && card.actions()[index].isAttackAction()) {
                    this.nextPlayerAndRunGame();
                    return;
                }
                this.runGame();
            }
        });
    }

    private void nextPlayerAndRunGame() {
        CardPlayer lastPlayer = this.currentPlayer;
        this.getActiveCard(lastPlayer).ifPresent(card -> card.setEffect(Effect.NONE));
        ++this.round;
        this.usedEnergy = false;
        this.usedAbility = false;
        this.usedItem = false;
        this.currentPlayer = this.currentPlayer == this.firstPlayer ? this.secondPlayer : this.firstPlayer;
        GameSlot activeSlot = this.getActiveSlot(this.currentPlayer);
        GameSlot handSlot = this.getPlayerHand(this.currentPlayer);
        GameSlot deckSlot = this.getDeckSlot(this.currentPlayer);
        this.getActiveCard(this.currentPlayer).ifPresent(card -> {
            if (card.getHealth() <= 0) {
                this.play(this.currentPlayer, (Component)Component.empty().append(card.getName()).append(" foi derrotado"));
                activeSlot.clear();
                int n = lastPlayer == this.firstPlayer ? 0 : 1;
                this.victories[n] = this.victories[n] + 1;
            } else if (card.getEffect() == Effect.BANCO) {
                this.play(this.currentPlayer, (Component)Component.empty().append(card.getName()).append(" voltou para o banco"));
                card.setEffect(Effect.NONE);
                activeSlot.clear();
                handSlot.add((Card)card);
            }
        });
        int amount = handSlot.size();
        if (amount < 5) {
            for (int i = 0; i < 5 - amount; ++i) {
                if (deckSlot.isEmpty()) continue;
                ArkaniaCard card2 = (ArkaniaCard)deckSlot.removeLast();
                card2.flip();
                handSlot.add((Card)card2);
                this.getCensoredHand(this.currentPlayer).add((Card)card2);
            }
        }
        if (this.getActiveCard(this.currentPlayer).isEmpty()) {
            if (this.victories[lastPlayer == this.firstPlayer ? 0 : 1] >= (Integer)this.REQUIRED_WINS.get()) {
                this.endGame();
            } else if (this.getPlayerHand(this.currentPlayer).stream().noneMatch(c -> {
                ArkaniaCard card;
                return c instanceof ArkaniaCard && (card = (ArkaniaCard)((Object)c)).isSpecialist();
            })) {
                this.endGame();
            } else {
                this.runGame();
            }
        } else {
            this.runGame();
        }
    }

    public void endGame() {
        CardPlayer lastPlayer;
        this.isGameOver = true;
        CardPlayer cardPlayer = lastPlayer = this.currentPlayer == this.firstPlayer ? this.secondPlayer : this.firstPlayer;
        if (this.getActiveCard(this.currentPlayer).isEmpty()) {
            if (this.victories[lastPlayer == this.firstPlayer ? 0 : 1] >= (Integer)this.REQUIRED_WINS.get()) {
                lastPlayer.sendTitle((Component)Component.literal((String)"Vencedor").withStyle(ChatFormatting.GREEN), (Component)Component.literal((String)"Voc\u00ea derrotou ").append(this.currentPlayer.getName()).append(" " + String.valueOf(this.REQUIRED_WINS.get()) + " vezes"));
                this.currentPlayer.sendTitle((Component)Component.literal((String)"Perdedor").withStyle(ChatFormatting.RED), (Component)lastPlayer.getName().copy().append(" te derrotou " + String.valueOf(this.REQUIRED_WINS.get()) + " vezes"));
            } else if (this.getPlayerHand(this.currentPlayer).stream().noneMatch(c -> {
                ArkaniaCard card;
                return c instanceof ArkaniaCard && (card = (ArkaniaCard)((Object)c)).isSpecialist();
            })) {
                lastPlayer.sendTitle((Component)Component.literal((String)"Vencedor").withStyle(ChatFormatting.GREEN), (Component)this.currentPlayer.getName().copy().append(" n\u00e3o tem mais especialistas no banco"));
                this.currentPlayer.sendTitle((Component)Component.literal((String)"Perdedor").withStyle(ChatFormatting.RED), (Component)Component.literal((String)"Voc\u00ea n\u00e3o tem mais especialistas no banco"));
            } else {
                lastPlayer.sendTitle((Component)Component.translatable((String)"message.charta.draw").withStyle(ChatFormatting.YELLOW), (Component)Component.translatable((String)"message.charta.no_winner"));
                this.currentPlayer.sendTitle((Component)Component.translatable((String)"message.charta.draw").withStyle(ChatFormatting.YELLOW), (Component)Component.translatable((String)"message.charta.no_winner"));
            }
        } else {
            lastPlayer.sendTitle((Component)Component.translatable((String)"message.charta.draw").withStyle(ChatFormatting.YELLOW), (Component)Component.translatable((String)"message.charta.no_winner"));
            this.currentPlayer.sendTitle((Component)Component.translatable((String)"message.charta.draw").withStyle(ChatFormatting.YELLOW), (Component)Component.translatable((String)"message.charta.no_winner"));
        }
    }

    public void play(CardPlayer player, Component play) {
        for (CardPlayer p : this.getPlayers()) {
            LivingEntity entity = p.getEntity();
            if (!(entity instanceof ServerPlayer)) continue;
            ServerPlayer serverPlayer = (ServerPlayer)entity;
            PacketDistributor.sendToPlayer((ServerPlayer)serverPlayer, (CustomPacketPayload)new CardPlayPayload((Component)(player.getName().equals((Object)Component.empty()) ? Component.empty() : player.getColoredName()), this.getPlayerHand(player).size(), play), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    protected GameSlot createPlayerHand(CardPlayer owner) {
        return new GameSlot(this, owner.hand()){

            public boolean canInsertCard(CardPlayer player, List<Card> cards, int index) {
                return false;
            }

            public boolean canRemoveCard(CardPlayer player, int index) {
                return false;
            }
        };
    }

    public Optional<ArkaniaCard> getActiveCard(CardPlayer player) {
        Card card;
        GameSlot activeSlot = this.getActiveSlot(player);
        if (!activeSlot.isEmpty() && (card = activeSlot.getLast()) instanceof ArkaniaCard) {
            ArkaniaCard card2 = (ArkaniaCard)card;
            return Optional.of(card2);
        }
        return Optional.empty();
    }

    public GameSlot getActiveSlot(CardPlayer player) {
        return this.activeSlots.get(player == this.firstPlayer ? 0 : 1);
    }

    public GameSlot getDeckSlot(CardPlayer player) {
        return this.deckSlots.get(player == this.firstPlayer ? 0 : 1);
    }

    public CardPlayer getOpponent(CardPlayer player) {
        return player == this.firstPlayer ? this.secondPlayer : this.firstPlayer;
    }

    public boolean isFirstRound() {
        return this.round < 2;
    }

    public boolean hasUsedEnergy() {
        return this.usedEnergy;
    }

    public void setUsedEnergy(boolean usedEnergy) {
        this.usedEnergy = usedEnergy;
    }

    public boolean hasUsedAbility() {
        return this.usedAbility;
    }

    public void setUsedAbility(boolean usedAbility) {
        this.usedAbility = usedAbility;
    }

    public boolean hasUsedItem() {
        return this.usedItem;
    }

    public void setUsedItem(boolean usedItem) {
        this.usedItem = usedItem;
    }

    public int getVictories(CardPlayer player) {
        return this.victories[player == this.firstPlayer ? 0 : 1];
    }

    public void setVictories(CardPlayer player, int victories) {
        this.victories[player == this.firstPlayer ? 0 : 1] = victories;
    }

    public int getMinPlayers() {
        return 1;
    }

    public int getMaxPlayers() {
        return 2;
    }

    public List<GameOption<?>> getOptions() {
        return List.of(this.REQUIRED_WINS);
    }
}

