/*
 * Decompiled with CFR 0.152.
 */
package br.com.arkanis.arkanyamon.game;

import br.com.arkanis.arkanyamon.Arkanyamon;
import br.com.arkanis.arkanyamon.game.ArkaniaCard;
import com.google.common.collect.ImmutableList;
import dev.lucaargolo.charta.game.Suit;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class ArkaniaElement
extends Suit {
    private static final ResourceLocation FONT = Arkanyamon.id("elements");
    private static final List<ArkaniaElement> values = new ArrayList<ArkaniaElement>();
    private final Component descriptor;
    private final char icon;
    private final ResourceLocation texture;
    private final int darkColor;
    private final int lightColor;
    private final Supplier<ArkaniaCard> cardSupplier;
    public static final ArkaniaElement MEDO = new ArkaniaElement("medo", (Component)Component.literal((String)" do Medo "), 'M', 4074137, 9910757, () -> ArkaniaCard.AMORA);
    public static final ArkaniaElement GANGUE = new ArkaniaElement("gangue", (Component)Component.literal((String)" da Gangue "), 'G', 1396691, 176127, () -> ArkaniaCard.MILO);
    public static final ArkaniaElement OBSTINADOS = new ArkaniaElement("obstinados", (Component)Component.literal((String)" dos Obstinados "), 'O', 1280067, 5489464, () -> ArkaniaCard.DENIX);
    public static final ArkaniaElement ESSYS = new ArkaniaElement("essys", (Component)Component.literal((String)" de Essys "), 'E', 15825462, 16768878, () -> ArkaniaCard.TUCUPI);
    public static final ArkaniaElement DILUICAO = new ArkaniaElement("diluicao", (Component)Component.literal((String)" de Diluicao "), 'D', 16732292, 16221911, () -> ArkaniaCard.IRIS);
    public static final ArkaniaElement ARKA = new ArkaniaElement("arka", (Component)Component.literal((String)" de Arka "), 'A', 5197175, 9009116, () -> ArkaniaCard.TREVOR);
    public static final ArkaniaElement ARKANYA = new ArkaniaElement("arkanya", (Component)Component.literal((String)" de Arkanya "), 'N', 12264462, 14440738, () -> ArkaniaCard.GRIS);
    public static final ArkaniaElement NORMAL = new ArkaniaElement("normal", (Component)Component.literal((String)" do Normal "), 'B', 0x8F858F, 0xE3DEDD, () -> ArkaniaCard.GOHAN_GROOVE);
    public static final ArkaniaElement SANGUE = new ArkaniaElement("sangue", (Component)Component.literal((String)" de Sangue "), 'S', 10494240, 0xFF5555, () -> ArkaniaCard.HORUS);

    public ArkaniaElement(String name, Component descriptor, char icon, int darkColor, int lightColor, Supplier<ArkaniaCard> cardSupplier) {
        super(Arkanyamon.id(name));
        this.descriptor = descriptor;
        this.icon = icon;
        this.texture = Arkanyamon.id("textures/energy/" + name + ".png");
        this.darkColor = darkColor;
        this.lightColor = lightColor;
        this.cardSupplier = cardSupplier;
        values.add(this);
    }

    public ArkaniaCard getCard() {
        return this.cardSupplier.get();
    }

    public Component getName() {
        return Component.translatable((String)("energy.arkanyamon." + this.name())).withStyle(ChatFormatting.ITALIC).withStyle(s -> s.withColor(this.darkColor));
    }

    public Component getIcon() {
        return Component.literal((String)String.valueOf(this.icon)).withStyle(s -> s.withFont(FONT).withColor(0xFFFFFF));
    }

    public String name() {
        return this.location().getPath();
    }

    public Component descriptor() {
        return this.descriptor;
    }

    public char icon() {
        return this.icon;
    }

    public int darkColor() {
        return this.darkColor;
    }

    public int lightColor() {
        return this.lightColor;
    }

    public ResourceLocation texture() {
        return this.texture;
    }

    public static List<ArkaniaElement> values() {
        return ImmutableList.copyOf(values);
    }
}

