/*
 * Decompiled with CFR 0.152.
 */
package br.com.arkanis.arkanyamon.game;

import br.com.arkanis.arkanyamon.Arkanyamon;
import br.com.arkanis.arkanyamon.game.ArkaniaCard;
import br.com.arkanis.arkanyamon.game.ArkaniaElement;
import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Pair;
import dev.lucaargolo.charta.game.Deck;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Rarity;

public class ArkaniaDeck
extends Deck {
    public static final ResourceLocation IMAGE = Arkanyamon.id("textures/card/deck.png");
    public static ArkaniaDeck INSTANCE;

    public ArkaniaDeck(Collection<ArkaniaCard> arkaniaCards) {
        super(Rarity.COMMON, false, (List)ImmutableList.copyOf(arkaniaCards), suit -> {
            ResourceLocation resourceLocation;
            if (suit instanceof ArkaniaElement) {
                ArkaniaElement element = (ArkaniaElement)((Object)suit);
                resourceLocation = element.texture();
            } else {
                resourceLocation = Arkanyamon.EMPTY;
            }
            return resourceLocation;
        }, suit -> {
            Object object;
            if (suit instanceof ArkaniaElement) {
                ArkaniaElement element = (ArkaniaElement)((Object)suit);
                object = "arkanyamon.energy." + element.name();
            } else {
                object = "suit.charta.unknown";
            }
            return object;
        }, card -> {
            ResourceLocation resourceLocation;
            if (card instanceof ArkaniaCard) {
                ArkaniaCard arkania = (ArkaniaCard)((Object)card);
                resourceLocation = arkania.texture();
            } else {
                resourceLocation = Arkanyamon.EMPTY;
            }
            return resourceLocation;
        }, card -> {
            Object object;
            if (!card.flipped() && card instanceof ArkaniaCard) {
                ArkaniaCard arkania = (ArkaniaCard)((Object)card);
                object = "card.arkanyamon." + arkania.name();
            } else {
                object = "card.charta.unknown";
            }
            return object;
        }, () -> IMAGE, () -> "item.arkanyamon.play_mat");
    }

    public static List<Pair<List<Component>, Boolean>> verifyDeck(List<ArkaniaCard> cards) {
        ArrayList<Pair<List<Component>, Boolean>> verify = new ArrayList<Pair<List<Component>, Boolean>>();
        List<ArkaniaCard> specialists = cards.stream().filter(ArkaniaCard::isSpecialist).toList();
        Set elements = cards.stream().filter(a -> a.element != null).map(a -> a.element).collect(Collectors.toSet());
        if (specialists.size() < 3) {
            String amount = specialists.isEmpty() ? "0 Cartas de Especialista" : (specialists.size() == 1 ? "1 Carta de Especialista" : specialists.size() + " Cartas de Especialista");
            List<MutableComponent> component = List.of(Component.literal((String)("Voc\u00ea tem " + amount + " ")), Component.literal((String)"(\u00c9 necess\u00e1rio ter no minimo 3 Cartas de Especialista no seu deck)").withStyle(ChatFormatting.RED));
            verify.add((Pair<List<Component>, Boolean>)Pair.of(component, (Object)true));
            return verify;
        }
        if (specialists.size() > 5) {
            String amount = specialists.size() + " Cartas de Especialista";
            List<MutableComponent> component = List.of(Component.literal((String)("Voc\u00ea tem " + amount + " ")), Component.literal((String)"(\u00c9 necess\u00e1rio ter no m\u00e1ximo 5 Cartas de Especialista no seu deck)").withStyle(ChatFormatting.RED));
            verify.add((Pair<List<Component>, Boolean>)Pair.of(component, (Object)true));
            return verify;
        }
        if (elements.size() > 2) {
            List<MutableComponent> component = List.of(Component.literal((String)("Voc\u00ea tem " + elements.size() + " elementos diferentes no seu deck ")), Component.literal((String)"(\u00c9 recomendado ter no m\u00e1ximo 2 elementos no seu deck)").withStyle(ChatFormatting.YELLOW));
            verify.add((Pair<List<Component>, Boolean>)Pair.of(component, (Object)false));
        }
        for (ArkaniaElement element : ArkaniaElement.values()) {
            List<ArkaniaCard> elementSpecialists = cards.stream().filter(a -> a.element == element && a.isSpecialist()).toList();
            List<ArkaniaCard> elementEnergies = cards.stream().filter(a -> a.element == element && a.isEnergy()).toList();
            if (elementEnergies.size() < elementSpecialists.size() * 2) {
                MutableComponent condition = (elementEnergies.isEmpty() ? Component.literal((String)" e nenhuma ") : Component.literal((String)"e apenas ")).append(element.getCard().getDescriptor(elementEnergies.size()));
                List<MutableComponent> component = List.of(Component.literal((String)"Voc\u00ea tem ").append(elementSpecialists.get(0).getDescriptor(elementSpecialists.size())).append((Component)condition).append(" "), Component.literal((String)"(\u00c9 necess\u00e1rio ter no m\u00ednimo 2 Cartas de Energia por Carta de Especialista)").withStyle(ChatFormatting.RED));
                verify.add((Pair<List<Component>, Boolean>)Pair.of(component, (Object)true));
                continue;
            }
            if (elementEnergies.size() >= elementSpecialists.size() * 4) continue;
            List<MutableComponent> component = List.of(Component.literal((String)"Voc\u00ea tem ").append(elementSpecialists.get(0).getDescriptor(elementSpecialists.size())).append(" e apenas ").append(element.getCard().getDescriptor(elementEnergies.size())).append(" "), Component.literal((String)"(\u00c9 recomendado ter no m\u00ednimo 4 Cartas de Energia por Carta de Especialista)").withStyle(ChatFormatting.YELLOW));
            verify.add((Pair<List<Component>, Boolean>)Pair.of(component, (Object)false));
        }
        return verify;
    }
}

