/*
 * Decompiled with CFR 0.152.
 */
package br.com.arkanis.arkanyamon.game;

import br.com.arkanis.arkanyamon.Arkanyamon;
import br.com.arkanis.arkanyamon.game.ArkaniaDeck;
import br.com.arkanis.arkanyamon.game.ArkaniaElement;
import br.com.arkanis.arkanyamon.game.ArkaniaGame;
import br.com.arkanis.arkanyamon.game.Effect;
import br.com.arkanis.arkanyamon.game.actions.Action;
import br.com.arkanis.arkanyamon.menu.ArkaniaGameMenu;
import dev.lucaargolo.charta.game.Card;
import dev.lucaargolo.charta.game.Rank;
import dev.lucaargolo.charta.game.Suit;
import io.netty.buffer.ByteBuf;
import java.util.Collection;
import java.util.HashMap;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.ChatFormatting;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import org.apache.commons.lang3.ArrayUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ArkaniaCard
extends Card
implements TooltipComponent {
    private static final HashMap<String, ArkaniaCard> registry = new HashMap();
    public static final StreamCodec<FriendlyByteBuf, ArkaniaCard> STREAM_CODEC = new StreamCodec<FriendlyByteBuf, ArkaniaCard>(){

        @NotNull
        public ArkaniaCard decode(@NotNull FriendlyByteBuf buf) {
            ResourceLocation name = buf.readResourceLocation();
            ArkaniaCard card = ArkaniaCard.loadOrThrow(name.getPath()).copy();
            if (card.flipped() != buf.readBoolean()) {
                card.flip();
            }
            card.setHealth(buf.readInt());
            card.setEnergy(buf.readInt());
            card.setEffect((Effect)buf.readEnum(Effect.class));
            return card;
        }

        public void encode(@NotNull FriendlyByteBuf buf, @NotNull ArkaniaCard value) {
            buf.writeResourceLocation(Arkanyamon.id(value.name));
            buf.writeBoolean(value.flipped());
            buf.writeInt(value.health);
            buf.writeInt(value.energy);
            buf.writeEnum((Enum)value.effect);
        }
    };
    protected final String name;
    @Nullable
    protected final Type type;
    protected final boolean male;
    protected final Action[] actions;
    protected final int energyRequiredToRetreat;
    protected int health;
    protected int energy = 0;
    protected Effect effect = Effect.NONE;
    protected ResourceLocation texture;
    @Nullable
    protected ArkaniaElement element;
    @Nullable
    protected ArkaniaElement weakness;
    protected ArkaniaCard original = null;
    public static final ArkaniaCard BLANK = new ArkaniaCard("blank", null, null, new Action[0]);
    public static final ArkaniaCard AMORA = new ArkaniaCard("amora", Type.ENERGY, ArkaniaElement.MEDO, new Action[0]);
    public static final ArkaniaCard MILO = new ArkaniaCard("milo", Type.ENERGY, ArkaniaElement.GANGUE, new Action[0]);
    public static final ArkaniaCard DENIX = new ArkaniaCard("denix", Type.ENERGY, ArkaniaElement.OBSTINADOS, new Action[0]);
    public static final ArkaniaCard TUCUPI = new ArkaniaCard("tucupi", Type.ENERGY, ArkaniaElement.ESSYS, new Action[0]);
    public static final ArkaniaCard TREVOR = new ArkaniaCard("trevor", Type.ENERGY, ArkaniaElement.ARKA, new Action[0]);
    public static final ArkaniaCard IRIS = new ArkaniaCard("iris", Type.ENERGY, ArkaniaElement.DILUICAO, new Action[0]);
    public static final ArkaniaCard GRIS = new ArkaniaCard("gris", Type.ENERGY, ArkaniaElement.ARKANYA, new Action[0]);
    public static final ArkaniaCard GOHAN_GROOVE = new ArkaniaCard("gohan_groove", Type.ENERGY, ArkaniaElement.NORMAL, new Action[0]);
    public static final ArkaniaCard HORUS = new ArkaniaCard("horus", Type.ENERGY, ArkaniaElement.SANGUE, new Action[0]);

    public ArkaniaCard(String name, int health, boolean male, int energyRequiredToRetreat, @Nullable Type type, @Nullable ArkaniaElement element, @Nullable ArkaniaElement weakness, Action ... actions) {
        super((Suit)(element != null ? element : Suit.BLANK), new Rank(Arkanyamon.id(name.replace("_", "")), -1));
        this.name = name;
        this.health = health;
        this.male = male;
        this.energyRequiredToRetreat = energyRequiredToRetreat;
        this.type = type;
        this.element = element;
        this.weakness = weakness;
        this.texture = type != null ? Arkanyamon.id("textures/card/" + type.name + "/" + name + ".png") : ArkaniaDeck.IMAGE;
        this.actions = actions;
        registry.put(name, this);
    }

    public ArkaniaCard(String name, @Nullable Type type, @Nullable ArkaniaElement element, Action ... actions) {
        this(name, 0, false, 0, type, element, null, actions);
    }

    protected ArkaniaCard(ArkaniaCard original) {
        super(original.suit(), original.rank(), original.flipped());
        this.name = original.name;
        this.health = original.health;
        this.male = original.male;
        this.energyRequiredToRetreat = original.energyRequiredToRetreat;
        this.energy = original.energy;
        this.effect = original.effect;
        this.type = original.type;
        this.element = original.element;
        this.weakness = original.weakness;
        this.texture = original.texture;
        this.actions = original.actions;
        this.original = original;
    }

    public ArkaniaCard getOriginal() {
        return this.original;
    }

    public boolean isOriginal() {
        return this.original == null;
    }

    public Component getName() {
        return Component.translatable((String)("card.arkanyamon." + this.name)).withStyle(s -> s.withColor(this.lightColor()));
    }

    public int lightColor() {
        return this.element != null ? this.element.lightColor() : 0xFFFFFF;
    }

    public int darkColor() {
        return this.element != null ? this.element.darkColor() : 0x666666;
    }

    public Component getDescriptor(int qnt) {
        MutableComponent mutableComponent;
        MutableComponent descriptor = this.element == null ? Component.empty() : this.element.descriptor();
        int color = this.darkColor();
        if (this.type == null) {
            mutableComponent = Component.literal((String)(qnt == 0 ? "Carta Vazia" : (qnt > 1 ? qnt + " Cartas Vazias" : "1 Carta Vazia")));
        } else {
            switch (this.type.ordinal()) {
                default: {
                    throw new MatchException(null, null);
                }
                case 1: {
                    mutableComponent = Component.literal((String)(qnt == 0 ? "Carta de Especialista" : (qnt > 1 ? qnt + " Cartas de Especialista" : "1 Carta de Especialista"))).append((Component)descriptor).withStyle(s -> s.withColor(color));
                    break;
                }
                case 0: {
                    mutableComponent = Component.literal((String)(qnt == 0 ? "Carta de Energia" : (qnt > 1 ? qnt + " Cartas de Energia" : "1 Carta de Energia"))).append((Component)descriptor).withStyle(s -> s.withColor(color));
                    break;
                }
                case 2: {
                    mutableComponent = Component.literal((String)(qnt == 0 ? "Carta de Item" : (qnt > 1 ? qnt + " Cartas de Item" : "1 Carta de Item"))).append((Component)descriptor).withStyle(s -> s.withColor(color));
                }
            }
        }
        return mutableComponent;
    }

    public int getMaxHealth() {
        ArkaniaCard parent = this;
        while (!parent.isOriginal()) {
            parent = parent.getOriginal();
        }
        return parent.getHealth();
    }

    public boolean isMale() {
        return this.male;
    }

    public int getHealth() {
        return this.health;
    }

    public void setHealth(int health) {
        this.health = health;
    }

    public int getEnergy() {
        return this.energy;
    }

    public void setEnergy(int energy) {
        this.energy = energy;
    }

    public Effect getEffect() {
        return this.effect;
    }

    public void setEffect(Effect effect) {
        this.effect = effect;
    }

    public ArkaniaCard copy() {
        return new ArkaniaCard(this);
    }

    public void flip() {
        if (this.original != null) {
            super.flip();
        }
    }

    public boolean equals(Object o) {
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ArkaniaCard card = (ArkaniaCard)((Object)o);
        return this.health == card.health && this.energy == card.energy && this.effect == card.effect;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.health, this.energy, this.effect});
    }

    public int compareTo(Card other) {
        if (other instanceof ArkaniaCard) {
            int cmp;
            ArkaniaCard o = (ArkaniaCard)other;
            if (this.type == null && o.type != null) {
                return -1;
            }
            if (this.type != null && o.type == null) {
                return 1;
            }
            if (this.type != null && (cmp = this.type.compareTo(o.type)) != 0) {
                return cmp;
            }
            if (this.element == null && o.element != null) {
                return -1;
            }
            if (this.element != null && o.element == null) {
                return 1;
            }
            if (this.element != null && (cmp = this.element.compareTo(o.element)) != 0) {
                return cmp;
            }
            return this.name.compareTo(o.name);
        }
        return super.compareTo(other);
    }

    public String name() {
        return this.name;
    }

    @Nullable
    public Type type() {
        return this.type;
    }

    @Nullable
    public ArkaniaElement element() {
        return this.element;
    }

    @Nullable
    public ArkaniaElement weakness() {
        return this.weakness;
    }

    public Action[] actions() {
        return this.actions;
    }

    public ResourceLocation texture() {
        return this.effect == Effect.CALVO ? this.texture.withPath(p -> p.replace(".png", "_careca.png")) : this.texture;
    }

    public static Collection<ArkaniaCard> values() {
        return registry.values();
    }

    public static ArkaniaCard loadOrThrow(String name) {
        return Optional.ofNullable(registry.get(name)).orElseThrow();
    }

    @Nullable
    public static ArkaniaCard load(String name) {
        return registry.get(name);
    }

    public boolean isSpecialist() {
        return this.type == Type.SPECIALIST;
    }

    public boolean isEnergy() {
        return this.type == Type.ENERGY;
    }

    public boolean isItem() {
        return this.type == Type.ITEM;
    }

    public boolean canRetreat() {
        return this.energy >= this.energyRequiredToRetreat;
    }

    public boolean canAttack(ArkaniaGameMenu menu) {
        return this.canUse(menu, Action::isAttackAction);
    }

    public boolean canUse(ArkaniaGameMenu menu, Predicate<Action> predicate) {
        for (Action action : this.actions) {
            if (!this.canUse(action, predicate, menu)) continue;
            return true;
        }
        return false;
    }

    public boolean canUse(Action action, Predicate<Action> predicate, ArkaniaGameMenu menu) {
        if (predicate.test(action)) {
            if (action.canExecute(this, menu.getCardPlayer(), (ArkaniaGame)menu.getGame(), null)) {
                return true;
            }
            Set<ArkaniaCard> targets = menu.getAvailableSpecialists(action.getChooseAction()).keySet();
            for (ArkaniaCard target : targets) {
                if (!action.canExecute(this, menu.getCardPlayer(), (ArkaniaGame)menu.getGame(), target)) continue;
                return true;
            }
        }
        return false;
    }

    @Nullable
    public Action getFirstAttack() {
        Action[] actions;
        for (Action action : actions = this.actions) {
            if (!action.isAttackAction()) continue;
            return action;
        }
        return null;
    }

    public boolean canUseFirstAttack(boolean bench, ArkaniaGameMenu menu) {
        Action action = this.getFirstAttack();
        if (action != null) {
            return this.canUse(action, bench ? Action::canExecuteInBench : Action::isAttackAction, menu);
        }
        return false;
    }

    @Nullable
    public Action getSecondAttack() {
        Object[] actions = this.actions;
        for (int i = 1 + ArrayUtils.indexOf((Object[])actions, (Object)this.getFirstAttack()); i < actions.length; ++i) {
            Object action = actions[i];
            if (!action.isAttackAction()) continue;
            return action;
        }
        return null;
    }

    public boolean canUseSecondAttack(boolean bench, ArkaniaGameMenu menu) {
        Action action = this.getSecondAttack();
        if (action != null) {
            return this.canUse(action, bench ? Action::canExecuteInBench : Action::isAttackAction, menu);
        }
        return false;
    }

    public boolean isUsable() {
        return this.getUsable() != null;
    }

    @Nullable
    public Action getUsable() {
        Action[] actions;
        for (Action action : actions = this.actions) {
            if (action.isAttackAction()) continue;
            return action;
        }
        return null;
    }

    public static enum Type {
        ENERGY("energy"),
        SPECIALIST("specialist"),
        ITEM("item");

        public static final StreamCodec<ByteBuf, Type> STREAM_CODEC;
        public final String name;

        private Type(String name) {
            this.name = name;
        }

        public Component getName() {
            return Component.translatable((String)("type.arkanyamon." + this.name)).withStyle(new ChatFormatting[]{ChatFormatting.GRAY, ChatFormatting.ITALIC});
        }

        static {
            STREAM_CODEC = ByteBufCodecs.idMapper(i -> Type.values()[i], Enum::ordinal);
        }
    }
}

