/*
 * Decompiled with CFR 0.152.
 */
package br.com.arkanis.arkanyamon.events;

import br.com.arkanis.arkanyamon.Arkanyamon;
import br.com.arkanis.arkanyamon.Command;
import br.com.arkanis.arkanyamon.RevealedData;
import br.com.arkanis.arkanyamon.ScheduledGiftData;
import br.com.arkanis.arkanyamon.game.ArkaniaCard;
import br.com.arkanis.arkanyamon.game.ArkaniaDeck;
import br.com.arkanis.arkanyamon.game.ArkaniaPack;
import br.com.arkanis.arkanyamon.menu.ArkaniaDeckMenu;
import br.com.arkanis.arkanyamon.network.RevealedDataPayload;
import com.mojang.brigadier.CommandDispatcher;
import java.util.Collection;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.RegisterCommandsEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.server.ServerStartingEvent;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;
import net.neoforged.neoforge.event.tick.ServerTickEvent;
import net.neoforged.neoforge.network.PacketDistributor;

@EventBusSubscriber(modid="arkanyamon", bus=EventBusSubscriber.Bus.GAME)
public class CommonEvents {
    @SubscribeEvent
    public static void onCommandRegister(RegisterCommandsEvent event) {
        Command.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
    }

    @SubscribeEvent
    public static void onServerStarting(ServerStartingEvent event) {
        Collection<ArkaniaPack> packs = ArkaniaPack.values();
        Collection<ArkaniaCard> cards = ArkaniaCard.values();
        Arkanyamon.LOGGER.info("Injecting " + cards.size() + " Arkanyamon cards from " + packs.size() + " packs");
        ArkaniaDeck.INSTANCE = new ArkaniaDeck(cards);
    }

    @SubscribeEvent
    public static void onPlayerJoin(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            PacketDistributor.sendToPlayer((ServerPlayer)serverPlayer, (CustomPacketPayload)new RevealedDataPayload(RevealedData.get(serverPlayer.server)), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    @SubscribeEvent
    public static void onServerTick(ServerTickEvent.Post event) {
        MinecraftServer server = event.getServer();
        ScheduledGiftData.get(server).tick(server);
    }

    @SubscribeEvent
    public static void onPlayerTick(PlayerTickEvent.Post event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            player = player2.containerMenu;
            if (player instanceof ArkaniaDeckMenu) {
                ArkaniaDeckMenu menu = (ArkaniaDeckMenu)player;
                SimpleContainer container = menu.getContainer();
                for (int slot = 0; slot < container.getContainerSize(); ++slot) {
                    ItemStack stack = container.getItem(slot);
                    stack.inventoryTick(player2.level(), (Entity)player2, -1, false);
                }
            }
        }
    }
}

