/*
 * Decompiled with CFR 0.152.
 */
package br.com.arkanis.arkanyamon.client.tooltip;

import br.com.arkanis.arkanyamon.game.ArkaniaCard;
import br.com.arkanis.arkanyamon.game.ArkaniaElement;
import br.com.arkanis.arkanyamon.game.Effect;
import com.mojang.blaze3d.vertex.PoseStack;
import dev.lucaargolo.charta.client.ChartaClient;
import dev.lucaargolo.charta.utils.ChartaGuiGraphics;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public record ArkaniaCardTooltip(ArkaniaCard card, Type type) implements ClientTooltipComponent
{
    private static final int SCALE = 30;
    private static final int WIDTH = 375;
    private static final int HEIGHT = 525;

    public ArkaniaCardTooltip(ArkaniaCard card) {
        this(card, Type.AUTO);
    }

    public void renderImage(@NotNull Font font, int x, int y, @NotNull GuiGraphics guiGraphics) {
        int width = (int)(375.0f / this.factor());
        int height = (int)(525.0f / this.factor());
        int offset = (int)(20.0f / this.factor());
        if (this.type == Type.EXPANDED_LEFT) {
            x += width + offset;
        }
        PoseStack stack = guiGraphics.pose();
        ChartaClient.CARD_INSET.accept(Float.valueOf(0.0f));
        ChartaClient.CARD_FOV.accept(Float.valueOf(90.0f));
        ChartaClient.CARD_X_ROT.accept(Float.valueOf(0.0f));
        ChartaClient.CARD_Y_ROT.accept(Float.valueOf(0.0f));
        ChartaGuiGraphics.blitCard((GuiGraphics)guiGraphics, (ResourceLocation)this.card.texture(), (float)((float)x - (float)width / 2.0f), (float)((float)(y - 13) - (float)height / 2.0f), (float)(width * 2), (float)(height * 2));
        if (this.isExtended() && this.card.type() == ArkaniaCard.Type.SPECIALIST) {
            float textOffset;
            if (this.card.getEffect() != Effect.NONE) {
                guiGraphics.blit(this.card.getEffect().texture(), x, y - 13, 0.0f, 0.0f, 16, 16, 16, 16);
            }
            ArkaniaElement element = Objects.requireNonNull(this.card.element());
            int maxHealth = this.card.getMaxHealth();
            int health = this.card.getHealth();
            float p = (float)health / (float)maxHealth;
            int energy = this.card.getEnergy();
            int barWidth = (int)(375.0f / this.factor());
            int barHeight = (int)(30.0f / this.factor());
            float textScale = 3.0f / this.factor();
            if (this.type == Type.EXPANDED_LEFT) {
                offset *= -1;
                x -= width + barWidth;
                textOffset = ((float)((y -= height - barHeight) + height) - 13.0f - (float)barHeight / 2.0f + 18.0f / this.factor()) / textScale;
            } else if (this.type == Type.EXPANDED_DOWN) {
                x -= width + offset;
                textOffset = ((float)((y += barHeight * 3) + height) - 13.0f - (float)barHeight / 2.0f - 42.0f / this.factor()) / textScale;
            } else {
                textOffset = ((float)(y + height) - 13.0f - (float)barHeight / 2.0f - 42.0f / this.factor()) / textScale;
            }
            guiGraphics.fill(x + width + offset, y + height - barHeight - 13, x + width + offset + barWidth, y + height - 13, -13434880);
            guiGraphics.fill(x + width + offset, y + height - 13 - barHeight, x + width + offset + (int)(p * (float)barWidth), y + height - 13, -6750208);
            stack.pushPose();
            stack.scale(textScale, textScale, 1.0f);
            String vida = "Vida: " + health + "/" + maxHealth;
            guiGraphics.drawString(font, vida, ((float)(x + width + offset) + (float)barWidth / 2.0f - (float)font.width(vida) * textScale / 2.0f) / textScale, ((float)(y + height) - 13.0f - (float)barHeight / 2.0f - 12.0f / this.factor()) / textScale, 0xFFFFFF, true);
            if (energy > 0) {
                MutableComponent component = Component.literal((String)"Energia: ").append((Component)element.getIcon().copy());
                for (int i = 1; i < energy; ++i) {
                    component = component.append(element.getIcon());
                }
                guiGraphics.drawString(font, component.getVisualOrderText(), ((float)(x + width + offset) + (float)barWidth / 2.0f - (float)font.width((FormattedText)component) * textScale / 2.0f) / textScale, textOffset, 0xFFFFFF, true);
            } else {
                String energia = "Sem energia";
                guiGraphics.drawString(font, energia, ((float)(x + width + offset) + (float)barWidth / 2.0f - (float)font.width(energia) * textScale / 2.0f) / textScale, textOffset, 0xFFFFFF, true);
            }
            stack.popPose();
        }
    }

    private boolean isExtended() {
        return this.isExtendedWidth() || this.isExtendedHeight();
    }

    private boolean isExtendedWidth() {
        return this.type != Type.SMALL && this.type != Type.EXPANDED_DOWN && (this.type != Type.AUTO || this.card.getEnergy() > 0 || this.card.getHealth() != this.card.getMaxHealth() || this.card.getEffect() != Effect.NONE);
    }

    private boolean isExtendedHeight() {
        return this.type == Type.EXPANDED_DOWN;
    }

    private float factor() {
        float maxHeight;
        Minecraft minecraft = Minecraft.getInstance();
        float factor = (float)minecraft.getWindow().getGuiScale();
        float scaledHeight = 525.0f / factor - 11.0f;
        if (scaledHeight > (maxHeight = (float)minecraft.getWindow().getGuiScaledHeight() / 2.0f)) {
            float minFactor = 525.0f / (maxHeight + 11.0f);
            return Math.max(factor, minFactor);
        }
        return factor;
    }

    public int getWidth(@NotNull Font font) {
        return this.getWidth();
    }

    public int getWidth() {
        return this.isExtendedWidth() ? (int)(20.0f / this.factor()) + Mth.floor((float)(375.0f / this.factor())) * 2 : Mth.floor((float)(375.0f / this.factor()));
    }

    public int getHeight() {
        return this.isExtendedHeight() ? (int)(60.0f / this.factor()) + Mth.floor((float)(525.0f / this.factor())) : Mth.floor((float)(525.0f / this.factor())) - 11;
    }

    public static enum Type {
        AUTO,
        SMALL,
        EXPANDED_RIGHT,
        EXPANDED_LEFT,
        EXPANDED_DOWN;

    }
}

