/*
 * Decompiled with CFR 0.152.
 */
package br.com.arkanis.arkanyamon.client.screen;

import br.com.arkanis.arkanyamon.client.screen.ArkaniaButton;
import br.com.arkanis.arkanyamon.client.screen.ArkaniaGameScreen;
import br.com.arkanis.arkanyamon.client.tooltip.ArkaniaCardTooltip;
import br.com.arkanis.arkanyamon.game.ArkaniaCard;
import br.com.arkanis.arkanyamon.game.ArkaniaGame;
import br.com.arkanis.arkanyamon.game.actions.Action;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.datafixers.util.Pair;
import dev.lucaargolo.charta.Charta;
import dev.lucaargolo.charta.game.CardPlayer;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import org.jetbrains.annotations.NotNull;

public class TargetScreen
extends Screen {
    private final ArkaniaGameScreen parent;
    private final ArkaniaCard card;
    private final CardPlayer player;
    private final ArkaniaGame game;
    private final Action action;
    private final BiConsumer<ArkaniaCard, Integer> consumer;
    private final Map<ArkaniaCard, Integer> cards;
    private final Map<ArkaniaCardTooltip, ArkaniaButton> buttons;

    public TargetScreen(ArkaniaGameScreen parent, ArkaniaCard card, CardPlayer player, ArkaniaGame game, Action action, BiConsumer<ArkaniaCard, Integer> consumer, Map<ArkaniaCard, Integer> cards) {
        super((Component)Component.empty());
        this.parent = parent;
        this.card = card;
        this.player = player;
        this.game = game;
        this.action = action;
        this.consumer = consumer;
        this.cards = cards;
        this.buttons = new HashMap<ArkaniaCardTooltip, ArkaniaButton>();
    }

    protected void init() {
        super.init();
        this.buttons.clear();
        ArkaniaCardTooltip tooltip = new ArkaniaCardTooltip(ArkaniaCard.BLANK, ArkaniaCardTooltip.Type.EXPANDED_DOWN);
        int w = tooltip.getWidth() * this.cards.size() + 10 * (this.cards.size() - 1) + 20;
        int h = tooltip.getHeight();
        int x = this.width / 2 - w / 2;
        int y = this.height / 2 - h / 2;
        int i = 0;
        for (Map.Entry<ArkaniaCard, Integer> entry : this.cards.entrySet()) {
            ArkaniaCard target = entry.getKey();
            int index = entry.getValue();
            int xo = x + i * (tooltip.getWidth() + 10);
            if (i > 0) {
                xo += 20;
            }
            this.buttons.put(new ArkaniaCardTooltip(target, ArkaniaCardTooltip.Type.EXPANDED_DOWN), new ArkaniaButton(() -> this.action.isAttackAction() ? Component.literal((String)"Atacar") : Component.literal((String)"Usar"), () -> true, () -> {
                if (this.action.canExecute(this.card, this.player, this.game, target)) {
                    return this.action.isAttackAction() ? Pair.of((Object)Component.literal((String)"Clique para atacar"), (Object)true) : Pair.of((Object)Component.literal((String)"Clique para usar habilidade"), (Object)true);
                }
                return this.action.isAttackAction() ? Pair.of((Object)Component.literal((String)"N\u00e3o \u00e9 poss\u00edvel utilizar esse ataque"), (Object)false) : Pair.of((Object)Component.literal((String)"Essa habilidade n\u00e3o pode ser utilizada agora"), (Object)false);
            }, xo + tooltip.getWidth() / 2, y + h + 20, () -> this.action.isAttackAction() ? 0xBB3A33 : this.card.darkColor(), () -> {
                if (index >= 0) {
                    this.consumer.accept(this.card, index);
                } else {
                    this.consumer.accept(null, -1);
                }
                this.onClose();
            }));
            ++i;
        }
        if (this.parent != null) {
            MutableComponent back = Component.literal((String)"\ue5c4").withStyle(Charta.SYMBOLS);
            this.addRenderableWidget((GuiEventListener)new Button.Builder((Component)back, b -> this.onClose()).bounds(5, 5, 20, 20).tooltip(Tooltip.create((Component)Component.translatable((String)"message.charta.go_back"))).build());
        }
    }

    public void render(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.render(guiGraphics, mouseX, mouseY, partialTick);
        this.buttons.forEach((tooltip, button) -> {
            if (button.visible().get().booleanValue()) {
                PoseStack stack = guiGraphics.pose();
                stack.pushPose();
                stack.translate((double)(-tooltip.getWidth()) / 2.0, (double)(-tooltip.getHeight() - 20), -500.0);
                tooltip.renderImage(this.font, button.x(), button.y(), guiGraphics);
                stack.popPose();
                button.renderCentered(this, guiGraphics, mouseX, mouseY);
            }
        });
    }

    public boolean mouseClicked(double mouseX, double mouseY, int id) {
        for (ArkaniaButton button : this.buttons.values()) {
            if (!button.visible().get().booleanValue() || !(mouseX >= (double)button.getCenteredX()) || !(mouseX <= (double)(button.getCenteredX() + button.getWidth())) || !(mouseY >= (double)button.getCenteredY()) || !(mouseY <= (double)(button.getCenteredY() + button.getHeight()))) continue;
            if (((Boolean)button.active().get().getSecond()).booleanValue()) {
                button.click();
            }
            return true;
        }
        return super.mouseClicked(mouseX, mouseY, id);
    }

    public void onClose() {
        if (this.minecraft != null) {
            this.minecraft.setScreen((Screen)this.parent);
        }
    }

    public boolean isPauseScreen() {
        return false;
    }
}

