/*
 * Decompiled with CFR 0.152.
 */
package br.com.arkanis.arkanyamon.client.screen;

import br.com.arkanis.arkanyamon.Arkanyamon;
import br.com.arkanis.arkanyamon.client.screen.ArkaniaButton;
import br.com.arkanis.arkanyamon.client.screen.ArkaniaPackScreen;
import br.com.arkanis.arkanyamon.events.ClientModEvents;
import br.com.arkanis.arkanyamon.game.ArkaniaCard;
import br.com.arkanis.arkanyamon.game.ArkaniaDeck;
import br.com.arkanis.arkanyamon.game.ArkaniaElement;
import br.com.arkanis.arkanyamon.game.ArkaniaPack;
import br.com.arkanis.arkanyamon.item.ArkaniaPackItem;
import br.com.arkanis.arkanyamon.network.OpenPayload;
import br.com.arkanis.arkanyamon.sound.ModSounds;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.datafixers.util.Pair;
import dev.lucaargolo.charta.Charta;
import dev.lucaargolo.charta.client.gui.components.CardWidget;
import dev.lucaargolo.charta.game.Card;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.client.model.renderable.CompositeRenderable;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;

public class PackOpenScreen
extends Screen {
    private static final ResourceLocation BLANK = Arkanyamon.id("textures/pack/blank.png");
    private final List<ArkaniaButton> buttons = new ArrayList<ArkaniaButton>();
    private final List<Pair<CardWidget, ArkaniaCard>> cards = new ArrayList<Pair<CardWidget, ArkaniaCard>>();
    private final ItemStack stack;
    private final ArkaniaPack pack;
    private final AtomicInteger mX = new AtomicInteger();
    private final AtomicInteger mY = new AtomicInteger();
    private long openTime = 0L;
    private boolean opening = false;
    private boolean opened = false;

    public PackOpenScreen(ItemStack stack) {
        super((Component)Component.empty());
        this.stack = stack;
        this.pack = ArkaniaPackItem.getPack(stack);
    }

    protected void init() {
        this.buttons.clear();
        this.buttons.add(new ArkaniaButton(() -> Component.literal((String)"Abrir"), () -> !this.opening, () -> Pair.of((Object)Component.literal((String)"Clique para abrir"), (Object)true), this.width / 2, this.height - 20, () -> 9924076, () -> {
            PacketDistributor.sendToServer((CustomPacketPayload)OpenPayload.PAYLOAD, (CustomPacketPayload[])new CustomPacketPayload[0]);
            this.openTime = System.currentTimeMillis();
            this.opening = true;
            Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)((SoundEvent)ModSounds.OPEN.get()), (float)1.0f));
        }));
        this.cards.clear();
        MutableComponent back = Component.literal((String)"\ue5c4").withStyle(Charta.SYMBOLS);
        this.addRenderableWidget((GuiEventListener)new Button.Builder((Component)back, b -> this.onClose()).bounds(5, 5, 20, 20).tooltip(Tooltip.create((Component)Component.translatable((String)"message.charta.go_back"))).build());
        MutableComponent cards = Component.literal((String)"\ue41d").withStyle(Charta.SYMBOLS);
        this.addRenderableWidget((GuiEventListener)new Button.Builder((Component)cards, b -> Minecraft.getInstance().setScreen((Screen)new ArkaniaPackScreen(this, this.pack))).bounds(this.width - 25, 5, 20, 20).tooltip(Tooltip.create((Component)Component.literal((String)"Conteudo do Pacote"))).build());
    }

    public void render(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        float eased;
        int millis = (int)(System.currentTimeMillis() - this.openTime);
        int tick = millis * 180 / 3000;
        if (tick > 120) {
            float t2 = (float)(tick - 120) / 60.0f;
            if (t2 > 1.0f) {
                t2 = 1.0f;
            }
            eased = -((float)(Math.cos(Math.PI * (double)t2) - 1.0)) / 2.0f;
        } else {
            eased = 0.0f;
        }
        this.mX.set(mouseX);
        this.mY.set(mouseY);
        if (this.cards.isEmpty()) {
            ArkaniaPackItem.getCards(this.stack).stream().map(card -> Pair.of((Object)new CardWidget(null, (Card)card, ArkaniaDeck.INSTANCE, 0.0f, 0.0f, 2.0f){

                public boolean isHovered() {
                    return (float)PackOpenScreen.this.mX.get() >= this.getPreciseX() && (float)PackOpenScreen.this.mX.get() <= this.getPreciseX() + this.getPreciseWidth() && (float)PackOpenScreen.this.mY.get() >= this.getPreciseY() && (float)PackOpenScreen.this.mY.get() <= this.getPreciseY() + this.getPreciseHeight();
                }
            }, (Object)card)).forEach(this.cards::add);
        }
        int y0 = 30;
        guiGraphics.fill(0, y0 - 2, this.width, y0 - 1, 0x55FFFFFF);
        guiGraphics.fill(0, y0 - 1, this.width, y0, -1442840576);
        guiGraphics.fill(0, y0, this.width, this.height, 0x66000000);
        super.render(guiGraphics, mouseX, mouseY, partialTick);
        guiGraphics.drawCenteredString(this.font, (Component)Component.literal((String)"Abertura de Pacote").withStyle(Style.EMPTY.withColor(9924076)), this.width / 2, 5, -1);
        guiGraphics.drawCenteredString(this.font, this.stack.getDisplayName(), this.width / 2, 15, -1);
        ResourceLocation texture = this.pack != null ? this.pack.texture() : BLANK;
        PoseStack poseStack = guiGraphics.pose();
        MultiBufferSource.BufferSource buffer = guiGraphics.bufferSource();
        poseStack.pushPose();
        poseStack.translate((double)this.width / 2.0, (double)this.height / 2.0 + 40.0, 0.0);
        poseStack.mulPose(new Matrix4f().scaling(1.0f, -1.0f, 1.0f));
        poseStack.scale(80.0f, 80.0f, 80.0f);
        Lighting.setupForFlatItems();
        if (this.opening && !this.opened) {
            if (millis < 3000) {
                poseStack.translate(0.0, (double)(-eased * 3.0f), 0.0);
                if (tick > 0 && tick < ClientModEvents.BOOSTER_PACK_ANIMATION.size()) {
                    ClientModEvents.BOOSTER_PACK_ANIMATION.get(tick).render(poseStack, (MultiBufferSource)buffer, t -> RenderType.entityCutout((ResourceLocation)texture), 0xF000F0, OverlayTexture.NO_OVERLAY, 1.0f, CompositeRenderable.Transforms.EMPTY);
                } else {
                    ClientModEvents.BOOSTER_PACK.render(poseStack, (MultiBufferSource)buffer, t -> RenderType.entityCutout((ResourceLocation)texture), 0xF000F0, OverlayTexture.NO_OVERLAY, 1.0f, CompositeRenderable.Transforms.EMPTY);
                }
            } else {
                this.opened = true;
            }
        } else if (!this.opened) {
            ClientModEvents.BOOSTER_PACK.render(poseStack, (MultiBufferSource)buffer, t -> RenderType.entityCutout((ResourceLocation)texture), 0xF000F0, OverlayTexture.NO_OVERLAY, 1.0f, CompositeRenderable.Transforms.EMPTY);
        }
        poseStack.popPose();
        if (this.opening && tick > 120) {
            float totalWidth = (float)this.cards.stream().mapToDouble(w -> (double)((CardWidget)w.getFirst()).getPreciseWidth() + 10.0).sum() - 10.0f;
            for (int i = this.cards.size() - 1; i >= 0; --i) {
                float t3 = Mth.clamp((float)((float)(tick - 120 - Math.abs(i - 2) * 10) / 60.0f), (float)0.0f, (float)1.0f);
                eased = -((float)(Math.cos(Math.PI * (double)t3) - 1.0)) / 2.0f;
                Pair<CardWidget, ArkaniaCard> pair = this.cards.get(i);
                CardWidget widget = (CardWidget)pair.getFirst();
                ArkaniaCard card2 = (ArkaniaCard)((Object)pair.getSecond());
                float startX = (float)this.width / 2.0f - widget.getPreciseWidth() / 2.0f;
                float finalX = (float)this.width / 2.0f - totalWidth / 2.0f + (float)i * (widget.getPreciseWidth() + 10.0f);
                float x = Mth.lerp((float)eased, (float)startX, (float)finalX);
                float a = Mth.clamp((float)((float)(tick - 150) / 50.0f), (float)0.1f, (float)1.0f);
                ArkaniaElement element = card2.element();
                MutableComponent name = Component.empty().append(card2.getName());
                if (element != null) {
                    name.append(" ").append(element.getIcon());
                }
                List ns = this.font.split((FormattedText)name, (int)widget.getPreciseWidth() + 12);
                int j = ns.size() - 1;
                for (FormattedCharSequence s : ns) {
                    guiGraphics.drawCenteredString(this.font, s, (int)(x + widget.getPreciseWidth() / 2.0f), this.height / 2 - 65 - j * 10, (int)(a * 255.0f) << 24 | 0xFFFFFF);
                    --j;
                }
                widget.setPreciseX(x);
                widget.setPreciseY((float)this.height / 2.0f - widget.getPreciseWidth() / 2.0f - 10.0f);
                widget.tick(mouseX, mouseY);
                widget.render(guiGraphics, mouseX, mouseY, partialTick);
                Component descriptor = card2.getDescriptor(0);
                List ds = this.font.split((FormattedText)descriptor, (int)widget.getPreciseWidth() * 2);
                guiGraphics.pose().pushPose();
                guiGraphics.pose().scale(0.5f, 0.5f, 1.0f);
                int k = 0;
                for (FormattedCharSequence s : ds) {
                    guiGraphics.drawCenteredString(this.font, s, (int)(x + widget.getPreciseWidth() / 2.0f) * 2, (this.height / 2 + 68 + k * 5) * 2, (int)(a * 255.0f) << 24 | 0xFFFFFF);
                    ++k;
                }
                guiGraphics.pose().popPose();
                if (!widget.isHovered()) continue;
                guiGraphics.renderTooltip(this.font, List.of(Component.empty()), Optional.of(card2), mouseX, mouseY);
            }
        }
        this.buttons.forEach(button -> {
            if (button.visible().get().booleanValue()) {
                button.renderCentered(this, guiGraphics, mouseX, mouseY);
            }
        });
    }

    public boolean mouseClicked(double mouseX, double mouseY, int id) {
        for (ArkaniaButton button : this.buttons) {
            if (!button.visible().get().booleanValue() || !(mouseX >= (double)button.getCenteredX()) || !(mouseX <= (double)(button.getCenteredX() + button.getWidth())) || !(mouseY >= (double)button.getCenteredY()) || !(mouseY <= (double)(button.getCenteredY() + button.getHeight()))) continue;
            if (((Boolean)button.active().get().getSecond()).booleanValue()) {
                button.click();
            }
            return true;
        }
        return super.mouseClicked(mouseX, mouseY, id);
    }

    public boolean isPauseScreen() {
        return false;
    }
}

