/*
 * Decompiled with CFR 0.152.
 */
package br.com.arkanis.arkanyamon.client.screen;

import br.com.arkanis.arkanyamon.Arkanyamon;
import br.com.arkanis.arkanyamon.game.ArkaniaCard;
import br.com.arkanis.arkanyamon.game.ArkaniaDeck;
import br.com.arkanis.arkanyamon.game.ArkaniaPack;
import dev.lucaargolo.charta.Charta;
import dev.lucaargolo.charta.client.gui.components.CardWidget;
import dev.lucaargolo.charta.client.gui.screens.CardScreen;
import dev.lucaargolo.charta.game.Card;
import dev.lucaargolo.charta.game.Deck;
import dev.lucaargolo.charta.menu.CardSlot;
import dev.lucaargolo.charta.utils.HoverableRenderable;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ArkaniaPackScreen
extends CardScreen
implements HoverableRenderable {
    private final Screen parent;
    private final ArkaniaPack pack;
    private ArkaniaCard hoveredCard;

    public ArkaniaPackScreen(@Nullable Screen parent, @Nullable ArkaniaPack pack) {
        super((Component)Component.empty());
        this.parent = parent;
        this.pack = pack;
    }

    protected void init() {
        if (this.parent != null) {
            MutableComponent back = Component.literal((String)"\ue5c4").withStyle(Charta.SYMBOLS);
            this.addRenderableWidget((GuiEventListener)new Button.Builder((Component)back, b -> this.onClose()).bounds(5, 5, 20, 20).tooltip(Tooltip.create((Component)Component.translatable((String)"message.charta.go_back"))).build());
        }
        float cardWidth = CardSlot.getWidth((CardSlot.Type)CardSlot.Type.DEFAULT);
        float cardHeight = CardSlot.getHeight((CardSlot.Type)CardSlot.Type.DEFAULT);
        List<ArkaniaCard> cards = this.pack != null ? this.pack.cards().stream().sorted().map(ArkaniaCard::copy).toList() : ArkaniaCard.values().stream().sorted().filter(card -> card != ArkaniaCard.BLANK && card.isOriginal()).toList();
        int cardsPerRow = (int)((float)this.width / (cardWidth + 5.0f));
        int rows = Mth.ceil((float)((float)cards.size() / (float)cardsPerRow));
        float maxWidth = (float)this.width - 20.0f;
        float maxLeftOffset = cardWidth + cardWidth / 10.0f;
        float maxHeight = (float)this.height - 80.0f;
        float maxTopOffset = cardHeight + cardHeight / 10.0f;
        float topOffset = cardHeight + Math.max(0.0f, maxHeight - (float)rows * cardHeight / (float)rows);
        float totalHeight = cardHeight + topOffset * ((float)rows - 1.0f);
        float topExcess = totalHeight - maxHeight;
        if (topExcess > 0.0f) {
            topOffset -= topExcess / ((float)rows - 1.0f);
        }
        if (topOffset > maxTopOffset) {
            topOffset = maxTopOffset;
        }
        for (int i = 0; i < rows; ++i) {
            float leftOffset = cardWidth + Math.max(0.0f, maxWidth - (float)cardsPerRow * cardWidth / (float)cardsPerRow);
            float totalWidth = cardWidth + leftOffset * ((float)cardsPerRow - 1.0f);
            float leftExcess = totalWidth - maxWidth;
            if (leftExcess > 0.0f) {
                leftOffset -= leftExcess / ((float)cardsPerRow - 1.0f);
            }
            totalWidth = cardWidth + maxLeftOffset * ((float)cardsPerRow - 1.0f);
            float left = 0.0f;
            if (leftOffset > maxLeftOffset) {
                left = Math.max(leftOffset - maxLeftOffset, maxWidth - totalWidth);
                leftOffset = maxLeftOffset;
            }
            int j = 0;
            for (ArkaniaCard card2 : cards.subList(cardsPerRow * i, Math.min(cards.size(), cardsPerRow * i + cardsPerRow))) {
                if (!Arkanyamon.isCardRevealed(card2)) {
                    card2.flip();
                }
                CardWidget cardWidget = new CardWidget((HoverableRenderable)this, (Card)card2, (Deck)ArkaniaDeck.INSTANCE, 10.0f + leftOffset * (float)j + left / 2.0f, 45.0f + topOffset * (float)i, 1.0f);
                this.addRenderableWidget((GuiEventListener)cardWidget);
                ++j;
            }
        }
    }

    public void render(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        int y0 = 30;
        int y1 = this.height;
        guiGraphics.fill(0, y0, this.width, y1, 0x66000000);
        super.render(guiGraphics, mouseX, mouseY, partialTick);
        guiGraphics.fill(0, y0 - 2, this.width, y0 - 1, 0x55FFFFFF);
        guiGraphics.fill(0, y0 - 1, this.width, y0, -1442840576);
        if (this.pack != null) {
            guiGraphics.drawCenteredString(this.font, (Component)Component.literal((String)"Conteudos do Pacote").withStyle(Style.EMPTY.withColor(9924076)), this.width / 2, 5, -1);
            guiGraphics.drawCenteredString(this.font, this.pack.getName(), this.width / 2, 15, -1);
        } else {
            guiGraphics.drawCenteredString(this.font, (Component)Component.literal((String)"Arkanyamon").withStyle(Style.EMPTY.withColor(9924076)), this.width / 2, 5, -1);
            guiGraphics.drawCenteredString(this.font, "Cartas Dispon\u00edveis", this.width / 2, 15, -1);
        }
        if (this.hoveredCard != null) {
            guiGraphics.renderTooltip(this.font, List.of(Component.empty()), Optional.of(this.hoveredCard), mouseX, mouseY);
        }
        this.hoveredCard = null;
    }

    public void scheduleTooltip(Component component) {
        TranslatableContents translatable;
        MutableComponent mutable;
        ComponentContents componentContents;
        if (component instanceof MutableComponent && (componentContents = (mutable = (MutableComponent)component).getContents()) instanceof TranslatableContents && (translatable = (TranslatableContents)componentContents).getKey().startsWith("card.arkanyamon.")) {
            String name = translatable.getKey().replace("card.arkanyamon.", "");
            ArkaniaCard card = ArkaniaCard.load(name);
            if (card != null) {
                this.hoveredCard = card;
            }
        } else {
            super.scheduleTooltip((Component)Component.literal((String)"Voc\u00ea ainda n\u00e3o descobriu essa carta").withStyle(ChatFormatting.RED));
        }
    }

    public void onClose() {
        if (this.minecraft != null) {
            this.minecraft.setScreen(this.parent);
        }
    }
}

