/*
 * Decompiled with CFR 0.152.
 */
package br.com.arkanis.arkanyamon.client.screen;

import br.com.arkanis.arkanyamon.Arkanyamon;
import br.com.arkanis.arkanyamon.client.screen.ArkaniaButton;
import br.com.arkanis.arkanyamon.client.screen.ArkaniaPackScreen;
import br.com.arkanis.arkanyamon.client.screen.TargetScreen;
import br.com.arkanis.arkanyamon.client.tooltip.ArkaniaCardTooltip;
import br.com.arkanis.arkanyamon.game.ArkaniaCard;
import br.com.arkanis.arkanyamon.game.ArkaniaGame;
import br.com.arkanis.arkanyamon.game.actions.Action;
import br.com.arkanis.arkanyamon.menu.ArkaniaGameMenu;
import br.com.arkanis.arkanyamon.mixin.CardSlotAccessor;
import br.com.arkanis.arkanyamon.network.ActionPayload;
import br.com.arkanis.arkanyamon.network.ActivatePayload;
import br.com.arkanis.arkanyamon.network.ChargePayload;
import br.com.arkanis.arkanyamon.network.ContinuePayload;
import br.com.arkanis.arkanyamon.network.RetreatPayload;
import com.mojang.datafixers.util.Pair;
import dev.lucaargolo.charta.Charta;
import dev.lucaargolo.charta.client.ChartaClient;
import dev.lucaargolo.charta.client.gui.screens.GameScreen;
import dev.lucaargolo.charta.game.Card;
import dev.lucaargolo.charta.menu.AbstractCardMenu;
import dev.lucaargolo.charta.menu.CardSlot;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.neoforged.neoforge.network.PacketDistributor;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.tuple.Triple;
import org.jetbrains.annotations.NotNull;

public class ArkaniaGameScreen
extends GameScreen<ArkaniaGame, ArkaniaGameMenu> {
    private final ResourceLocation VICTORY = Arkanyamon.id("textures/gui/victory.png");
    private final LinkedList<Triple<Component, Integer, Component>> localHistory = new LinkedList();
    private final List<ArkaniaButton> buttons = new ArrayList<ArkaniaButton>();
    private int lastHistorySize = ChartaClient.LOCAL_HISTORY.size();
    private boolean attacking = false;
    private int handSlot = -1;
    private ArkaniaCard activeCard = null;
    private ArkaniaCard enemyCard = null;
    private ArkaniaCard focusedCard = null;
    private int focusedCardId = -1;

    public ArkaniaGameScreen(ArkaniaGameMenu menu, Inventory playerInventory, Component title) {
        super((AbstractCardMenu)menu, playerInventory, title);
    }

    protected void init() {
        this.imageWidth = this.width;
        this.imageHeight = this.height;
        int activeSlot = ((ArkaniaGameMenu)this.menu).cardSlots.size() - 4;
        this.handSlot = activeSlot + 2;
        float previewWidth = CardSlot.getWidth((CardSlot.Type)CardSlot.Type.PREVIEW) + 28.0f;
        float playersWidth = (float)activeSlot * previewWidth + ((float)activeSlot - 1.0f) * (previewWidth / 10.0f);
        for (int i = 0; i < activeSlot; ++i) {
            CardSlot slot = (CardSlot)((ArkaniaGameMenu)this.menu).cardSlots.get(i);
            ((CardSlotAccessor)slot).setX(26.0f + ((float)this.width / 2.0f - playersWidth / 2.0f) + (float)i * (previewWidth + previewWidth / 10.0f));
        }
        super.init();
        this.removeWidget((GuiEventListener)this.renderables.remove(2));
        MutableComponent cards = Component.literal((String)"\ue41d").withStyle(Charta.SYMBOLS);
        this.addRenderableWidget((GuiEventListener)new Button.Builder((Component)cards, b -> Minecraft.getInstance().setScreen((Screen)new ArkaniaPackScreen((Screen)this, null))).bounds(this.width - 25, 35, 20, 20).tooltip(Tooltip.create((Component)Component.literal((String)"Cartas Dispon\u00edveis"))).build());
        int totalWidth = Mth.floor((float)CardSlot.getWidth((CardSlot.Type)CardSlot.Type.HORIZONTAL)) + 10;
        int buttonX = this.width - 40 - totalWidth;
        int buttonY = this.height - 63;
        this.buttons.clear();
        this.buttons.add(new ArkaniaButton(() -> Component.literal((String)"Prosseguir"), () -> !this.localHistory.isEmpty(), () -> Pair.of((Object)Component.literal((String)"Prox\u00edma mensagem"), (Object)true), buttonX + totalWidth - 38, buttonY + 63 - 14, 0, () -> 4752058, this.localHistory::removeFirst));
        this.buttons.add(new ArkaniaButton(() -> Component.literal((String)"Ativar"), () -> this.localHistory.isEmpty() && ((ArkaniaGameMenu)this.menu).isCurrentPlayer() && this.activeCard == null, () -> {
            if (this.focusedCard != null) {
                if (this.focusedCard.type() == ArkaniaCard.Type.SPECIALIST) {
                    return Pair.of((Object)Component.literal((String)"Clique para ativar carta selecionada"), (Object)true);
                }
                return Pair.of((Object)Component.literal((String)"A carta selecionada deve ser do tipo especialista para ser ativada"), (Object)false);
            }
            return Pair.of((Object)Component.literal((String)"Selecione uma carta"), (Object)false);
        }, buttonX + totalWidth / 2, buttonY + 10 + 31, () -> 5867083, () -> {
            PacketDistributor.sendToServer((CustomPacketPayload)new ActivatePayload(this.focusedCardId), (CustomPacketPayload[])new CustomPacketPayload[0]);
            this.focusedCard = null;
        }));
        this.buttons.add(new ArkaniaButton(() -> Component.literal((String)"Continuar"), () -> this.localHistory.isEmpty() && !this.attacking && ((ArkaniaGameMenu)this.menu).isCurrentPlayer() && this.activeCard != null, () -> Pair.of((Object)Component.literal((String)"Termina sua jogada e passa para o proximo jogador"), (Object)true), buttonX + totalWidth / 2, buttonY + 31 - 21, 136, () -> 5867083, () -> PacketDistributor.sendToServer((CustomPacketPayload)ContinuePayload.PAYLOAD, (CustomPacketPayload[])new CustomPacketPayload[0])));
        this.buttons.add(new ArkaniaButton(() -> {
            if (this.focusedCard == null || this.focusedCard.isSpecialist()) {
                return Component.literal((String)"Atacar");
            }
            if (this.focusedCard.isEnergy()) {
                return Component.literal((String)"Carregar");
            }
            return Component.literal((String)"Usar");
        }, () -> this.localHistory.isEmpty() && !this.attacking && ((ArkaniaGameMenu)this.menu).isCurrentPlayer() && this.activeCard != null, () -> {
            if (this.focusedCard == null && this.activeCard.isSpecialist()) {
                if (((ArkaniaGameMenu)this.menu).isFirstRound()) {
                    return Pair.of((Object)Component.literal((String)"Voc\u00ea n\u00e3o pode atacar no primeiro round"), (Object)false);
                }
                if (this.activeCard.canAttack((ArkaniaGameMenu)this.menu)) {
                    return Pair.of((Object)Component.literal((String)"Clique para atacar com a carta ativa"), (Object)true);
                }
                return Pair.of((Object)Component.literal((String)"Voc\u00ea n\u00e3o tem energia suficiente para atacar"), (Object)false);
            }
            if (this.focusedCard != null) {
                if (this.focusedCard.isSpecialist()) {
                    if (((ArkaniaGameMenu)this.menu).isFirstRound()) {
                        return Pair.of((Object)Component.literal((String)"Voc\u00ea n\u00e3o pode atacar no primeiro round"), (Object)false);
                    }
                    if (!this.focusedCard.canAttack((ArkaniaGameMenu)this.menu)) {
                        return Pair.of((Object)Component.literal((String)"Voc\u00ea n\u00e3o tem energia suficiente para atacar"), (Object)false);
                    }
                    return Pair.of((Object)Component.literal((String)"Clique para atacar com a carta selecionada"), (Object)true);
                }
                if (this.focusedCard.isEnergy()) {
                    if (((ArkaniaGameMenu)this.menu).hasUsedEnergy()) {
                        return Pair.of((Object)Component.literal((String)"Voc\u00ea j\u00e1 utilizou uma carta de energia nessa rodada"), (Object)false);
                    }
                    if (this.focusedCard.element() != this.activeCard.element()) {
                        return Pair.of((Object)Component.literal((String)"Essa carta de energia n\u00e3o \u00e9 valida para o especialista ativo"), (Object)false);
                    }
                    return Pair.of((Object)Component.literal((String)"Clique para carregar a carta ativa"), (Object)true);
                }
                if (((ArkaniaGameMenu)this.menu).isFirstRound()) {
                    return Pair.of((Object)Component.literal((String)"Voc\u00ea n\u00e3o pode usar itens no primeiro round"), (Object)false);
                }
                if (((ArkaniaGameMenu)this.menu).hasUsedItem()) {
                    return Pair.of((Object)Component.literal((String)"Voc\u00ea j\u00e1 utilizou um item nessa rodada"), (Object)false);
                }
                if (!this.focusedCard.canUse((ArkaniaGameMenu)this.menu, Action::isUsableAction)) {
                    return Pair.of((Object)Component.literal((String)"Esse item n\u00e3o pode ser utilizado agora"), (Object)false);
                }
                return Pair.of((Object)Component.literal((String)"Clique para utilizar o item selecionado"), (Object)true);
            }
            return Pair.of((Object)Component.literal((String)"Essa carta n\u00e3o pode atacar"), (Object)false);
        }, buttonX + totalWidth / 2 - 35, buttonY + 31, () -> {
            if (this.focusedCard == null || this.focusedCard.isSpecialist()) {
                return 0xBB3A33;
            }
            if (this.focusedCard.isEnergy()) {
                return 12488983;
            }
            return 4752058;
        }, () -> {
            if (this.focusedCard == null || this.focusedCard.isSpecialist()) {
                this.attacking = true;
            } else if (this.focusedCard.isEnergy()) {
                PacketDistributor.sendToServer((CustomPacketPayload)new ChargePayload(this.focusedCardId, -1), (CustomPacketPayload[])new CustomPacketPayload[0]);
                this.focusedCard = null;
            } else {
                this.chooseTarget(this.focusedCard, 0, (targetCard, targetCardId) -> {
                    PacketDistributor.sendToServer((CustomPacketPayload)new ActionPayload(this.focusedCardId, (int)targetCardId, 0), (CustomPacketPayload[])new CustomPacketPayload[0]);
                    this.focusedCard = null;
                });
            }
        }));
        this.buttons.add(new ArkaniaButton(() -> {
            if (this.focusedCard != null && this.focusedCard.isEnergy()) {
                return Component.literal((String)"Descartar");
            }
            return Component.literal((String)"Carregar");
        }, () -> this.localHistory.isEmpty() && !this.attacking && ((ArkaniaGameMenu)this.menu).isCurrentPlayer() && this.activeCard != null, () -> {
            if (this.focusedCard != null && this.focusedCard.isEnergy()) {
                return Pair.of((Object)Component.literal((String)"Clique para descartar a carta selecionada"), (Object)true);
            }
            if (((ArkaniaGameMenu)this.menu).hasUsedEnergy()) {
                return Pair.of((Object)Component.literal((String)"Voc\u00ea j\u00e1 utilizou uma carta de energia nessa rodada"), (Object)false);
            }
            List<ArkaniaCard> availableEnergy = ((ArkaniaGameMenu)this.menu).getPlayerHand().stream().filter(ArkaniaCard::isEnergy).toList();
            if (availableEnergy.isEmpty()) {
                return Pair.of((Object)Component.literal((String)"Voc\u00ea n\u00e3o possui cartas de energia"), (Object)false);
            }
            if (this.focusedCard == null && this.activeCard.isSpecialist()) {
                List<ArkaniaCard> typeEnergy = availableEnergy.stream().filter(c -> c.element() == this.activeCard.element()).toList();
                if (typeEnergy.isEmpty()) {
                    return Pair.of((Object)Component.literal((String)"Voc\u00ea n\u00e3o possui cartas de energia para o especialista ativo"), (Object)false);
                }
                return Pair.of((Object)Component.literal((String)"Clique para carregar a carta ativa"), (Object)true);
            }
            if (this.focusedCard != null && this.focusedCard.isSpecialist()) {
                List<ArkaniaCard> typeEnergy = availableEnergy.stream().filter(c -> c.element() == this.focusedCard.element()).toList();
                if (typeEnergy.isEmpty()) {
                    return Pair.of((Object)Component.literal((String)"Voc\u00ea n\u00e3o possui cartas de energia para o especialista selecionado"), (Object)false);
                }
                return Pair.of((Object)Component.literal((String)"Clique para carregar a carta selecionada"), (Object)true);
            }
            return Pair.of((Object)Component.literal((String)"Essa carta n\u00e3o pode ser carregada"), (Object)false);
        }, buttonX + totalWidth / 2 + 35, buttonY + 31, () -> {
            if (this.focusedCard != null && this.focusedCard.isEnergy()) {
                return 0xBB3A33;
            }
            return 12488983;
        }, () -> {
            ArkaniaCard chargingCard = this.focusedCard != null ? this.focusedCard : Objects.requireNonNull(this.activeCard);
            ArkaniaCard elementCard = Objects.requireNonNull(chargingCard.element()).getCard();
            int index = ((ArkaniaGameMenu)this.menu).getPlayerHand().indexOf((Object)elementCard);
            if (index >= 0) {
                if (this.focusedCard != null) {
                    PacketDistributor.sendToServer((CustomPacketPayload)new ChargePayload(index, this.focusedCardId), (CustomPacketPayload[])new CustomPacketPayload[0]);
                    this.focusedCard = null;
                } else {
                    PacketDistributor.sendToServer((CustomPacketPayload)new ChargePayload(index, -1), (CustomPacketPayload[])new CustomPacketPayload[0]);
                }
            }
        }));
        this.buttons.add(new ArkaniaButton(() -> Component.literal((String)"Habilidade"), () -> this.localHistory.isEmpty() && !this.attacking && ((ArkaniaGameMenu)this.menu).isCurrentPlayer() && this.activeCard != null, () -> {
            if (((ArkaniaGameMenu)this.menu).isFirstRound()) {
                return Pair.of((Object)Component.literal((String)"Voc\u00ea n\u00e3o pode usar habilidades no primeiro round"), (Object)false);
            }
            if (((ArkaniaGameMenu)this.menu).hasUsedAbility()) {
                return Pair.of((Object)Component.literal((String)"Voc\u00ea j\u00e1 utilizou uma habilidade nessa rodada"), (Object)false);
            }
            if (this.focusedCard != null && this.focusedCard.isSpecialist() && this.focusedCard.isUsable()) {
                if (!this.focusedCard.canUse((ArkaniaGameMenu)this.menu, Action::isUsableAction)) {
                    return Pair.of((Object)Component.literal((String)"Essa habilidade n\u00e3o pode ser utilizada agora"), (Object)false);
                }
                return Pair.of((Object)Component.literal((String)"Clique para usar a habilidade da carta selecionada"), (Object)true);
            }
            if (this.activeCard.isUsable()) {
                if (!this.activeCard.canUse((ArkaniaGameMenu)this.menu, Action::isUsableAction)) {
                    return Pair.of((Object)Component.literal((String)"Essa habilidade n\u00e3o pode ser utilizada agora"), (Object)false);
                }
                return Pair.of((Object)Component.literal((String)"Clique para usar a habilidade da carta ativa"), (Object)true);
            }
            if (this.focusedCard == null) {
                return Pair.of((Object)Component.literal((String)"A carta ativa n\u00e3o possui habilidades"), (Object)false);
            }
            return Pair.of((Object)Component.literal((String)"A carta selecionada n\u00e3o possui habilidades"), (Object)false);
        }, buttonX + totalWidth / 2 - 35, buttonY + 31 + 21, () -> {
            if (this.focusedCard != null) {
                return this.focusedCard.darkColor();
            }
            if (this.activeCard != null) {
                return this.activeCard.darkColor();
            }
            return 4752058;
        }, () -> {
            if (this.focusedCard != null && this.focusedCard.isSpecialist() && this.focusedCard.isUsable()) {
                this.chooseTarget(this.focusedCard, 0, (targetCard, targetCardId) -> {
                    PacketDistributor.sendToServer((CustomPacketPayload)new ActionPayload(this.focusedCardId, (int)targetCardId, 0), (CustomPacketPayload[])new CustomPacketPayload[0]);
                    this.focusedCard = null;
                });
            } else {
                this.chooseTarget(this.activeCard, 0, (targetCard, targetCardId) -> PacketDistributor.sendToServer((CustomPacketPayload)new ActionPayload(-1, (int)targetCardId, 0), (CustomPacketPayload[])new CustomPacketPayload[0]));
            }
        }));
        this.buttons.add(new ArkaniaButton(() -> Component.literal((String)"Recuar"), () -> this.localHistory.isEmpty() && !this.attacking && ((ArkaniaGameMenu)this.menu).isCurrentPlayer() && this.activeCard != null, () -> {
            List<ArkaniaCard> availableSpecialists = ((ArkaniaGameMenu)this.menu).getPlayerHand().stream().filter(ArkaniaCard::isSpecialist).toList();
            if (availableSpecialists.isEmpty()) {
                return Pair.of((Object)Component.literal((String)"Voc\u00ea n\u00e3o possui um especialista reserva"), (Object)false);
            }
            if (this.activeCard.canRetreat()) {
                return Pair.of((Object)Component.literal((String)"Clique para substituir a carta ativa"), (Object)true);
            }
            return Pair.of((Object)Component.literal((String)"A carta selecionada n\u00e3o possui energia suficiente para recuar"), (Object)false);
        }, buttonX + totalWidth / 2 + 35, buttonY + 31 + 21, () -> 4752058, () -> PacketDistributor.sendToServer((CustomPacketPayload)RetreatPayload.PAYLOAD, (CustomPacketPayload[])new CustomPacketPayload[0])));
        this.buttons.add(new ArkaniaButton(() -> Component.literal((String)"Voltar"), () -> this.attacking, () -> Pair.of((Object)Component.literal((String)"Volta ao menu anterior"), (Object)true), buttonX + 36, buttonY + 31 - 12, 0, () -> 4752058, () -> {
            this.attacking = false;
        }));
        this.buttons.add(new ArkaniaButton(() -> {
            if (this.focusedCard != null && this.focusedCard.getFirstAttack() != null) {
                return this.focusedCard.getFirstAttack().getName(this.focusedCard).plainCopy();
            }
            return Optional.ofNullable(this.activeCard.getFirstAttack()).map(a -> a.getName(this.activeCard)).orElse((Component)Component.empty()).plainCopy();
        }, () -> this.attacking, () -> {
            if (this.focusedCard != null) {
                if (this.focusedCard.canUseFirstAttack(true, (ArkaniaGameMenu)this.menu)) {
                    return Pair.of((Object)Component.literal((String)"Clique para atacar"), (Object)true);
                }
                return Pair.of((Object)Component.literal((String)"N\u00e3o \u00e9 poss\u00edvel utilizar esse ataque"), (Object)false);
            }
            if (this.activeCard.canUseFirstAttack(false, (ArkaniaGameMenu)this.menu)) {
                return Pair.of((Object)Component.literal((String)"Clique para atacar"), (Object)true);
            }
            return Pair.of((Object)Component.literal((String)"N\u00e3o \u00e9 poss\u00edvel utilizar esse ataque"), (Object)false);
        }, buttonX + totalWidth / 2 + 35, buttonY + 31 - 12, () -> {
            if (this.focusedCard != null) {
                return this.focusedCard.darkColor();
            }
            if (this.activeCard != null) {
                return this.activeCard.darkColor();
            }
            return 4752058;
        }, () -> {
            if (this.focusedCard != null && this.focusedCard.canUseFirstAttack(true, (ArkaniaGameMenu)this.menu)) {
                int action = ArrayUtils.indexOf((Object[])this.focusedCard.actions(), (Object)this.focusedCard.getFirstAttack());
                this.chooseTarget(this.focusedCard, action, (targetCard, targetCardId) -> {
                    PacketDistributor.sendToServer((CustomPacketPayload)new ActionPayload(this.focusedCardId, (int)targetCardId, action), (CustomPacketPayload[])new CustomPacketPayload[0]);
                    this.focusedCard = null;
                });
            } else {
                int action = ArrayUtils.indexOf((Object[])this.activeCard.actions(), (Object)this.activeCard.getFirstAttack());
                this.chooseTarget(this.activeCard, action, (targetCard, targetCardId) -> PacketDistributor.sendToServer((CustomPacketPayload)new ActionPayload(-1, (int)targetCardId, action), (CustomPacketPayload[])new CustomPacketPayload[0]));
            }
        }));
        this.buttons.add(new ArkaniaButton(() -> {
            if (this.focusedCard != null && this.focusedCard.getSecondAttack() != null) {
                return this.focusedCard.getSecondAttack().getName(this.focusedCard).plainCopy();
            }
            return Optional.ofNullable(this.activeCard.getSecondAttack()).map(a -> a.getName(this.activeCard)).orElse((Component)Component.empty()).plainCopy();
        }, () -> this.attacking && (this.focusedCard != null && this.focusedCard.getSecondAttack() != null || this.focusedCard == null && this.activeCard.getSecondAttack() != null), () -> {
            if (this.focusedCard != null) {
                if (this.focusedCard.canUseSecondAttack(true, (ArkaniaGameMenu)this.menu)) {
                    return Pair.of((Object)Component.literal((String)"Clique para atacar"), (Object)true);
                }
                return Pair.of((Object)Component.literal((String)"N\u00e3o \u00e9 poss\u00edvel utilizar esse ataque"), (Object)false);
            }
            if (this.activeCard.canUseSecondAttack(false, (ArkaniaGameMenu)this.menu)) {
                return Pair.of((Object)Component.literal((String)"Clique para atacar"), (Object)true);
            }
            return Pair.of((Object)Component.literal((String)"N\u00e3o \u00e9 poss\u00edvel utilizar esse ataque"), (Object)false);
        }, buttonX + totalWidth / 2 + 35, buttonY + 31 + 12, () -> {
            if (this.focusedCard != null) {
                return this.focusedCard.darkColor();
            }
            if (this.activeCard != null) {
                return this.activeCard.darkColor();
            }
            return 4752058;
        }, () -> {
            if (this.focusedCard != null && this.focusedCard.canUseSecondAttack(true, (ArkaniaGameMenu)this.menu)) {
                int action = ArrayUtils.indexOf((Object[])this.focusedCard.actions(), (Object)this.focusedCard.getSecondAttack());
                this.chooseTarget(this.focusedCard, action, (targetCard, targetCardId) -> {
                    PacketDistributor.sendToServer((CustomPacketPayload)new ActionPayload(this.focusedCardId, (int)targetCardId, action), (CustomPacketPayload[])new CustomPacketPayload[0]);
                    this.focusedCard = null;
                });
            } else {
                int action = ArrayUtils.indexOf((Object[])this.activeCard.actions(), (Object)this.activeCard.getSecondAttack());
                this.chooseTarget(this.activeCard, action, (targetCard, targetCardId) -> PacketDistributor.sendToServer((CustomPacketPayload)new ActionPayload(-1, (int)targetCardId, action), (CustomPacketPayload[])new CustomPacketPayload[0]));
            }
        }));
    }

    private void chooseTarget(ArkaniaCard card, int action, BiConsumer<ArkaniaCard, Integer> consumer) {
        if (action > -1 && action < card.actions().length) {
            Action a = card.actions()[action];
            Map<ArkaniaCard, Integer> map = ((ArkaniaGameMenu)this.menu).getAvailableSpecialists(a.getChooseAction());
            if (map.size() > 1) {
                assert (this.minecraft != null);
                this.minecraft.setScreen((Screen)new TargetScreen(this, card, ((ArkaniaGameMenu)this.menu).getCardPlayer(), (ArkaniaGame)((ArkaniaGameMenu)this.menu).getGame(), a, consumer, map));
            } else {
                consumer.accept(null, -1);
            }
        } else {
            consumer.accept(null, -1);
        }
    }

    protected void renderBg(@NotNull GuiGraphics guiGraphics, float partialTick, int mouseX, int mouseY) {
    }

    public void renderTopBar(@NotNull GuiGraphics guiGraphics) {
        ArkaniaCardTooltip tooltip;
        if (this.activeCard != null) {
            tooltip = new ArkaniaCardTooltip(this.activeCard, ArkaniaCardTooltip.Type.EXPANDED_RIGHT);
            tooltip.renderImage(this.font, 40, this.height - tooltip.getHeight() - 63 - 5, guiGraphics);
        }
        if (this.enemyCard != null) {
            tooltip = new ArkaniaCardTooltip(this.enemyCard, ArkaniaCardTooltip.Type.EXPANDED_LEFT);
            tooltip.renderImage(this.font, this.width - 40 - tooltip.getWidth(), 74, guiGraphics);
        }
        super.renderTopBar(guiGraphics);
        int firstVictories = ((ArkaniaGameMenu)this.menu).isFirstPlayer() ? ((ArkaniaGameMenu)this.menu).getPlayerVictories() : ((ArkaniaGameMenu)this.menu).getEnemyVictories();
        for (int i = 0; i < firstVictories; ++i) {
            guiGraphics.blit(this.VICTORY, this.width / 2 - 8 - 84 - 20 * i, 8, 0.0f, 0.0f, 16, 16, 16, 16);
        }
        int secondVictories = ((ArkaniaGameMenu)this.menu).isFirstPlayer() ? ((ArkaniaGameMenu)this.menu).getEnemyVictories() : ((ArkaniaGameMenu)this.menu).getPlayerVictories();
        for (int i = 0; i < secondVictories; ++i) {
            guiGraphics.blit(this.VICTORY, this.width / 2 - 8 + 84 + 20 * i, 8, 0.0f, 0.0f, 16, 16, 16, 16);
        }
    }

    public void render(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        int historySize = ChartaClient.LOCAL_HISTORY.size();
        if (this.lastHistorySize != historySize) {
            int size;
            for (int i = size = Math.max(0, historySize - this.lastHistorySize); i > 0; --i) {
                this.localHistory.add((Triple<Component, Integer, Component>)((Triple)ChartaClient.LOCAL_HISTORY.get(historySize - i)));
            }
            this.lastHistorySize = historySize;
        }
        this.activeCard = ((ArkaniaGameMenu)this.menu).getPlayerCard();
        this.enemyCard = ((ArkaniaGameMenu)this.menu).getEnemyCard();
        super.render(guiGraphics, mouseX, mouseY, partialTick);
        if (this.hoveredCardSlot != null && !this.hoveredCardSlot.getSlot().isEmpty()) {
            Card card;
            Card card2 = card = this.hoveredCardId >= 0 ? this.hoveredCardSlot.getSlot().get(this.hoveredCardId) : null;
            if (card instanceof ArkaniaCard) {
                ArkaniaCard c = (ArkaniaCard)card;
                guiGraphics.renderTooltip(this.font, List.of(Component.empty()), Optional.of(c), mouseX, mouseY);
            }
        }
        int totalWidth = Mth.floor((float)CardSlot.getWidth((CardSlot.Type)CardSlot.Type.HORIZONTAL)) + 10;
        int buttonX = this.width - 40 - totalWidth;
        int buttonY = this.height - 63;
        if (!this.localHistory.isEmpty()) {
            Triple<Component, Integer, Component> triple = this.localHistory.getFirst();
            Component player = (Component)triple.getLeft();
            guiGraphics.drawString(this.font, player, buttonX + 5, buttonY + 5, 0xFFFFFF);
            Component play = (Component)triple.getRight();
            List list = this.font.split((FormattedText)play, totalWidth - 10);
            for (int i = 0; i < list.size(); ++i) {
                guiGraphics.drawString(this.font, (FormattedCharSequence)list.get(i), buttonX + 5, buttonY + 20 + i * 10, 0xFFFFFF);
            }
        } else if (!((ArkaniaGameMenu)this.menu).isCurrentPlayer()) {
            MutableComponent text = Component.literal((String)"Aguarde a sua vez");
            guiGraphics.drawString(this.font, (Component)text, buttonX + totalWidth / 2 - this.font.width((FormattedText)text) / 2, buttonY + 30, 0xFFFFFF);
        } else if (this.activeCard == null) {
            MutableComponent text = Component.literal((String)"Selecione um especialista");
            guiGraphics.drawString(this.font, (Component)text, buttonX + totalWidth / 2 - this.font.width((FormattedText)text) / 2, buttonY - 10 + 30, 0xFFFFFF);
        }
        this.buttons.forEach(button -> {
            if (button.visible().get().booleanValue()) {
                button.renderCentered((Screen)this, guiGraphics, mouseX, mouseY);
            }
        });
        this.attacking = this.attacking && this.localHistory.isEmpty() && ((ArkaniaGameMenu)this.menu).isCurrentPlayer() && this.activeCard != null;
    }

    public void scheduleTooltip(Component component) {
    }

    public void renderBottomBar(@NotNull GuiGraphics guiGraphics) {
        int totalWidth = Mth.floor((float)CardSlot.getWidth((CardSlot.Type)CardSlot.Type.HORIZONTAL)) + 10;
        guiGraphics.fill(0, this.height - 63, 40, this.height, -2013265920);
        guiGraphics.fill(40, this.height - 63, totalWidth + 40, this.height, -1996488705);
        guiGraphics.fill(totalWidth + 40, this.height - 63, this.width - 40 - totalWidth, this.height, -2013265920);
        guiGraphics.fill(this.width - 40 - totalWidth, this.height - 63, this.width - 40, this.height, -1996488705);
        guiGraphics.fill(this.width - 40, this.height - 63, this.width, this.height, -2013265920);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int id) {
        for (ArkaniaButton button : this.buttons) {
            if (!button.visible().get().booleanValue() || !(mouseX >= (double)button.getCenteredX()) || !(mouseX <= (double)(button.getCenteredX() + button.getWidth())) || !(mouseY >= (double)button.getCenteredY()) || !(mouseY <= (double)(button.getCenteredY() + button.getHeight()))) continue;
            if (((Boolean)button.active().get().getSecond()).booleanValue()) {
                button.click();
            }
            return true;
        }
        if (this.focusedCard != null) {
            this.focusedCard = null;
            this.focusedCardId = -1;
            return true;
        }
        if (this.hoveredCardSlot != null) {
            if (this.hoveredCardSlot.index == this.handSlot && !this.hoveredCardSlot.getSlot().isEmpty()) {
                Card card;
                Card card2 = card = this.hoveredCardId >= 0 ? this.hoveredCardSlot.getSlot().get(this.hoveredCardId) : this.hoveredCardSlot.getSlot().getLast();
                if (card instanceof ArkaniaCard) {
                    ArkaniaCard c;
                    this.focusedCard = c = (ArkaniaCard)card;
                    this.focusedCardId = this.hoveredCardId;
                }
            }
            return true;
        }
        return super.mouseClicked(mouseX, mouseY, id);
    }

    public ArkaniaCard getFocusedCard() {
        return this.focusedCard;
    }
}

