/*
 * Decompiled with CFR 0.152.
 */
package br.com.arkanis.arkanyamon.client.screen;

import br.com.arkanis.arkanyamon.Arkanyamon;
import br.com.arkanis.arkanyamon.game.ArkaniaDeck;
import br.com.arkanis.arkanyamon.item.ArkaniaDeckItem;
import br.com.arkanis.arkanyamon.menu.ArkaniaDeckMenu;
import br.com.arkanis.arkanyamon.network.RenameDeckBoxPayload;
import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;

public class ArkaniaDeckScreen
extends AbstractContainerScreen<ArkaniaDeckMenu> {
    private final ItemStack stack;
    private final ResourceLocation texture;
    private EditBox editBox;

    public ArkaniaDeckScreen(ArkaniaDeckMenu menu, Inventory playerInventory, Component title) {
        super((AbstractContainerMenu)menu, playerInventory, title);
        this.stack = menu.getStack();
        String textureId = this.stack.getItem().builtInRegistryHolder().key().location().getPath();
        this.texture = Arkanyamon.id("textures/gui/" + textureId + ".png");
        this.imageHeight = 218;
        this.inventoryLabelY += 54;
    }

    protected void init() {
        super.init();
        this.editBox = (EditBox)this.addRenderableWidget((GuiEventListener)new EditBox(this.font, this.leftPos + 36, this.topPos - 39, 106, 12, (Component)Component.empty()));
        this.editBox.setMaxLength(100);
        this.editBox.setBordered(false);
        this.editBox.setValue(this.stack.getHoverName().getString());
        this.editBox.setResponder(name -> {
            if (!this.stack.getHoverName().getString().equals(name)) {
                PacketDistributor.sendToServer((CustomPacketPayload)new RenameDeckBoxPayload((String)name), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        });
    }

    public void render(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.render(guiGraphics, mouseX, mouseY, partialTick);
        List<Pair<List<Component>, Boolean>> verify = ArkaniaDeck.verifyDeck(ArkaniaDeckItem.getCards(this.stack));
        int i = 0;
        for (Pair<List<Component>, Boolean> pair : verify) {
            if (((Boolean)pair.getSecond()).booleanValue()) {
                guiGraphics.blit(this.texture, this.leftPos + 150, this.topPos + 6 + i * 18, (float)this.imageWidth, 0.0f, 16, 16, 265, 265);
            } else {
                guiGraphics.blit(this.texture, this.leftPos + 150, this.topPos + 6 + i * 18, (float)this.imageWidth, 16.0f, 16, 16, 265, 265);
            }
            if (mouseX >= this.leftPos + 150 && mouseX <= this.leftPos + 166 && mouseY >= this.topPos + 6 + i * 18 && mouseY <= this.topPos + 6 + i * 18 + 16) {
                ArrayList<FormattedCharSequence> tooltip = new ArrayList<FormattedCharSequence>();
                for (Component component : (List)pair.getFirst()) {
                    if (!tooltip.isEmpty()) {
                        tooltip.add(Component.empty().getVisualOrderText());
                    }
                    tooltip.addAll(this.font.split((FormattedText)component, this.imageWidth));
                }
                this.setTooltipForNextRenderPass(tooltip);
            }
            ++i;
        }
        this.renderTooltip(guiGraphics, mouseX, mouseY);
    }

    protected void renderBg(@NotNull GuiGraphics guiGraphics, float partialTick, int mouseX, int mouseY) {
        guiGraphics.blit(this.texture, this.leftPos, this.topPos - 47, this.imageWidth, this.imageHeight + 47, 0.0f, 0.0f, this.imageWidth, this.imageHeight + 47, 265, 265);
    }

    protected void renderLabels(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY) {
        guiGraphics.drawString(this.font, this.playerInventoryTitle, this.inventoryLabelX, this.inventoryLabelY, 0x404040, false);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (!this.editBox.mouseClicked(mouseX, mouseY, button)) {
            this.setFocused(null);
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        assert (this.minecraft != null);
        InputConstants.Key key = InputConstants.getKey((int)keyCode, (int)scanCode);
        if (this.editBox.isFocused() && this.minecraft.options.keyInventory.isActiveAndMatches(key)) {
            return true;
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }
}

