/*
 * Decompiled with CFR 0.152.
 */
package br.com.arkanis.arkanyamon.client.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.datafixers.util.Pair;
import dev.lucaargolo.charta.client.gui.screens.GameScreen;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.sounds.SoundEvents;

public record ArkaniaButton(Supplier<Component> text, Supplier<Boolean> visible, Supplier<Pair<Component, Boolean>> active, int x, int y, int width, Supplier<Integer> color, Runnable onClick) {
    public ArkaniaButton(Supplier<Component> text, Supplier<Boolean> visible, Supplier<Pair<Component, Boolean>> active, int x, int y, Supplier<Integer> color, Runnable onClick) {
        this(text, visible, active, x, y, 65, color, onClick);
    }

    public void renderCentered(Screen screen, GuiGraphics guiGraphics, int mouseX, int mouseY) {
        int c = (Boolean)this.active.get().getSecond() != false ? this.color.get() : 0x666666;
        int width = this.getWidth();
        int x0 = this.getCenteredX();
        int y0 = this.getCenteredY();
        guiGraphics.fill(x0 + 1, y0 + 1, x0 + width - 1, y0 + 16, -16777216 + c);
        RenderSystem.setShaderColor((float)((float)(c >> 16 & 0xFF) / 255.0f), (float)((float)(c >> 8 & 0xFF) / 255.0f), (float)((float)(c & 0xFF) / 255.0f), (float)1.0f);
        guiGraphics.blit(GameScreen.WIDGETS, x0, y0, width, 18, 3.0f, 3.0f, 65, 18, 59, 0);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        guiGraphics.drawString(Minecraft.getInstance().font, this.text.get(), x0 + width / 2 - Minecraft.getInstance().font.width((FormattedText)this.text.get()) / 2, y0 + 5, -1);
        if (mouseX >= x0 && mouseX < x0 + width && mouseY >= y0 && mouseY < y0 + 18) {
            guiGraphics.fill(x0 + 1, y0 + 1, x0 + width - 1, y0 + 16, 0x33FFFFFF);
            screen.setTooltipForNextRenderPass(Tooltip.splitTooltip((Minecraft)Minecraft.getInstance(), (Component)((Component)this.active.get().getFirst())));
        }
    }

    public void click() {
        Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((Holder)SoundEvents.UI_BUTTON_CLICK, (float)1.0f));
        this.onClick.run();
    }

    public int getCenteredX() {
        return this.x - this.getWidth() / 2;
    }

    public int getCenteredY() {
        return this.y - this.getHeight() / 2;
    }

    public int getWidth() {
        return Math.max(this.width, Minecraft.getInstance().font.width((FormattedText)this.text.get()) + 10);
    }

    public int getHeight() {
        return 18;
    }
}

