/*
 * Decompiled with CFR 0.152.
 */
package br.com.arkanis.arkanyamon.client.item;

import br.com.arkanis.arkanyamon.Arkanyamon;
import br.com.arkanis.arkanyamon.events.ClientModEvents;
import br.com.arkanis.arkanyamon.game.ArkaniaPack;
import br.com.arkanis.arkanyamon.item.ArkaniaPackItem;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.client.extensions.common.IClientItemExtensions;
import net.neoforged.neoforge.client.model.renderable.CompositeRenderable;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class ArkaniaPackItemExtensions
implements IClientItemExtensions {
    private static final ResourceLocation BLANK = Arkanyamon.id("textures/pack/blank.png");

    public BlockEntityWithoutLevelRenderer getCustomRenderer() {
        Minecraft minecraft = Minecraft.getInstance();
        return new BlockEntityWithoutLevelRenderer(this, minecraft.getBlockEntityRenderDispatcher(), minecraft.getEntityModels()){

            public void renderByItem(@NotNull ItemStack stack, @NotNull ItemDisplayContext displayContext, @NotNull PoseStack poseStack, @NotNull MultiBufferSource buffer, int packedLight, int packedOverlay) {
                if (ClientModEvents.BOOSTER_PACK != null) {
                    ArkaniaPack pack = ArkaniaPackItem.getPack(stack);
                    ResourceLocation texture = pack != null ? pack.texture() : BLANK;
                    poseStack.pushPose();
                    poseStack.translate(0.5f, 0.25f, 0.0f);
                    poseStack.scale(0.5f, 0.5f, 0.5f);
                    ClientModEvents.BOOSTER_PACK.render(poseStack, buffer, t -> RenderType.entityCutout((ResourceLocation)texture), packedLight, packedOverlay, 1.0f, CompositeRenderable.Transforms.EMPTY);
                    poseStack.popPose();
                }
            }
        };
    }
}

