/*
 * Decompiled with CFR 0.152.
 */
package br.com.arkanis.arkanyamon.client.item;

import br.com.arkanis.arkanyamon.Arkanyamon;
import br.com.arkanis.arkanyamon.game.ArkaniaCard;
import br.com.arkanis.arkanyamon.game.ArkaniaDeck;
import br.com.arkanis.arkanyamon.item.ArkaniaDeckItem;
import com.mojang.blaze3d.vertex.PoseStack;
import dev.lucaargolo.charta.client.blockentity.CardTableBlockEntityRenderer;
import dev.lucaargolo.charta.game.Card;
import dev.lucaargolo.charta.game.Deck;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.client.extensions.common.IClientItemExtensions;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3f;

@OnlyIn(value=Dist.CLIENT)
public class ArkaniaDeckItemExtensions
implements IClientItemExtensions {
    private static final RandomSource RANDOM = RandomSource.create();

    public BlockEntityWithoutLevelRenderer getCustomRenderer() {
        final Minecraft minecraft = Minecraft.getInstance();
        return new BlockEntityWithoutLevelRenderer(this, minecraft.getBlockEntityRenderDispatcher(), minecraft.getEntityModels()){

            public void renderByItem(@NotNull ItemStack stack, @NotNull ItemDisplayContext displayContext, @NotNull PoseStack poseStack, @NotNull MultiBufferSource buffer, int packedLight, int packedOverlay) {
                String modelId = stack.getItem().builtInRegistryHolder().key().location().getPath().replace("deck_box", "deck_box_model");
                BakedModel model = minecraft.getModelManager().getModel(ModelResourceLocation.standalone((ResourceLocation)Arkanyamon.id("item/" + modelId)));
                minecraft.getItemRenderer().renderQuadList(poseStack, buffer.getBuffer(RenderType.cutout()), model.getQuads(null, null, RANDOM), stack, packedLight, packedOverlay);
                poseStack.pushPose();
                poseStack.translate(0.2, 0.05, 0.0);
                poseStack.scale(4.0f, 4.0f, 4.0f);
                poseStack.translate(-0.025, 0.0, 0.0);
                poseStack.scale(1.333f, 1.333f, 1.333f);
                List<ArkaniaCard> cards = ArkaniaDeckItem.getCards(stack);
                for (ArkaniaCard card : cards) {
                    poseStack.translate(0.0f, 0.0f, 0.0025f);
                    CardTableBlockEntityRenderer.drawCard((Deck)ArkaniaDeck.INSTANCE, (Card)card, (int)packedLight, (int)packedOverlay, (PoseStack)poseStack, (MultiBufferSource)buffer, (float)0.0f, (float)0.0f, (Vector3f)new Vector3f(0.0f, 0.0f, 1.0f));
                }
                poseStack.popPose();
            }
        };
    }
}

