/*
 * Decompiled with CFR 0.152.
 */
package br.com.arkanis.arkanyamon;

import br.com.arkanis.arkanyamon.Arkanyamon;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.saveddata.SavedData;
import org.jetbrains.annotations.NotNull;

public class ScheduledGiftData
extends SavedData {
    private static final String DATA_NAME = "arkanyamon_scheduled_gifts";
    private static final SavedData.Factory<ScheduledGiftData> FACTORY = new SavedData.Factory(ScheduledGiftData::new, ScheduledGiftData::load);
    private static final Codec<GiftEntry> GIFT_ENTRY_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("uuid").forGetter(entry -> entry.uuid.toString()), (App)ItemStack.CODEC.fieldOf("item").forGetter(entry -> entry.itemStack), (App)Codec.INT.fieldOf("ticks").forGetter(entry -> entry.remainingTicks)).apply((Applicative)instance, (uuidStr, stack, ticks) -> new GiftEntry(UUID.fromString(uuidStr), (ItemStack)stack, (int)ticks)));
    private static final Codec<List<GiftEntry>> LIST_CODEC = GIFT_ENTRY_CODEC.listOf();
    private final List<GiftEntry> scheduledGifts = new ArrayList<GiftEntry>();

    private ScheduledGiftData() {
    }

    private ScheduledGiftData(List<GiftEntry> gifts) {
        this.scheduledGifts.addAll(gifts);
    }

    public void schedule(ServerPlayer player, ItemStack stack, int ticks) {
        this.scheduledGifts.add(new GiftEntry(player.getUUID(), stack.copy(), ticks));
        this.setDirty();
    }

    public void tick(MinecraftServer server) {
        Iterator<GiftEntry> iter = this.scheduledGifts.iterator();
        while (iter.hasNext()) {
            GiftEntry entry = iter.next();
            ServerPlayer player = server.getPlayerList().getPlayer(entry.uuid);
            if (player == null) continue;
            --entry.remainingTicks;
            if (entry.remainingTicks > 0) continue;
            player.getInventory().placeItemBackInInventory(entry.itemStack);
            iter.remove();
            this.setDirty();
        }
    }

    @NotNull
    public CompoundTag save(@NotNull CompoundTag tag, @NotNull HolderLookup.Provider provider) {
        LIST_CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, this.scheduledGifts).resultOrPartial(System.err::println).ifPresent(nbt -> tag.put("Gifts", nbt));
        return tag;
    }

    private static ScheduledGiftData load(CompoundTag tag, @NotNull HolderLookup.Provider provider) {
        List gifts = LIST_CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)tag.get("Gifts")).resultOrPartial(Arkanyamon.LOGGER::error).orElse(new ArrayList());
        return new ScheduledGiftData(gifts);
    }

    public static ScheduledGiftData get(MinecraftServer server) {
        return (ScheduledGiftData)server.overworld().getDataStorage().computeIfAbsent(FACTORY, DATA_NAME);
    }

    private static class GiftEntry {
        private final UUID uuid;
        private final ItemStack itemStack;
        private int remainingTicks;

        public GiftEntry(UUID uuid, ItemStack itemStack, int remainingTicks) {
            this.uuid = uuid;
            this.itemStack = itemStack;
            this.remainingTicks = remainingTicks;
        }
    }
}

