/*
 * Decompiled with CFR 0.152.
 */
package br.com.arkanis.arkanyamon;

import br.com.arkanis.arkanyamon.game.ArkaniaCard;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.saveddata.SavedData;
import org.jetbrains.annotations.NotNull;

public class RevealedData
extends SavedData {
    private static final SavedData.Factory<RevealedData> FACTORY = new SavedData.Factory(RevealedData::new, RevealedData::load);
    public static final StreamCodec<FriendlyByteBuf, RevealedData> STREAM_CODEC = new StreamCodec<FriendlyByteBuf, RevealedData>(){

        @NotNull
        public RevealedData decode(@NotNull FriendlyByteBuf buffer) {
            return RevealedData.load(buffer);
        }

        public void encode(@NotNull FriendlyByteBuf buffer, RevealedData value) {
            value.save(buffer);
        }
    };
    public static RevealedData LOCAL = new RevealedData();
    private final Map<UUID, Set<String>> reveledCards = new HashMap<UUID, Set<String>>();

    public boolean isCardRevealed(Player player, ArkaniaCard card) {
        if (player == null || card == null) {
            return false;
        }
        return this.reveledCards.getOrDefault(player.getUUID(), Set.of()).contains(card.name());
    }

    public boolean revealCard(Player player, ArkaniaCard card) {
        if (this.reveledCards.computeIfAbsent(player.getUUID(), k -> new HashSet()).add(card.name())) {
            this.setDirty();
            return true;
        }
        return false;
    }

    public boolean hideCard(Player player, ArkaniaCard card) {
        if (this.reveledCards.computeIfAbsent(player.getUUID(), k -> new HashSet()).remove(card.name())) {
            this.setDirty();
            return true;
        }
        return false;
    }

    @NotNull
    public CompoundTag save(@NotNull CompoundTag compoundTag, @NotNull HolderLookup.Provider provider) {
        ListTag playersList = new ListTag();
        for (Map.Entry<UUID, Set<String>> entry : this.reveledCards.entrySet()) {
            CompoundTag playerTag = new CompoundTag();
            playerTag.putUUID("UUID", entry.getKey());
            ListTag cardsList = new ListTag();
            for (String card : entry.getValue()) {
                cardsList.add((Object)StringTag.valueOf((String)card));
            }
            playerTag.put("Cards", (Tag)cardsList);
            playersList.add((Object)playerTag);
        }
        compoundTag.put("RevealedData", (Tag)playersList);
        return compoundTag;
    }

    public static RevealedData load(@NotNull CompoundTag compoundTag, @NotNull HolderLookup.Provider provider) {
        RevealedData data = new RevealedData();
        ListTag playersList = compoundTag.getList("RevealedData", 10);
        for (Tag tag : playersList) {
            if (!(tag instanceof CompoundTag)) continue;
            CompoundTag playerTag = (CompoundTag)tag;
            UUID uuid = playerTag.getUUID("UUID");
            HashSet<String> cards = new HashSet<String>();
            ListTag cardsList = playerTag.getList("Cards", 8);
            for (Tag cardTag : cardsList) {
                cards.add(cardTag.getAsString());
            }
            data.reveledCards.put(uuid, cards);
        }
        return data;
    }

    public void save(FriendlyByteBuf buf) {
        buf.writeVarInt(this.reveledCards.size());
        for (Map.Entry<UUID, Set<String>> entry : this.reveledCards.entrySet()) {
            buf.writeUUID(entry.getKey());
            buf.writeVarInt(entry.getValue().size());
            for (String cardName : entry.getValue()) {
                buf.writeUtf(cardName);
            }
        }
    }

    public static RevealedData load(FriendlyByteBuf buf) {
        RevealedData data = new RevealedData();
        int playerCount = buf.readVarInt();
        for (int i = 0; i < playerCount; ++i) {
            UUID uuid = buf.readUUID();
            int cardCount = buf.readVarInt();
            HashSet<String> cards = new HashSet<String>();
            for (int j = 0; j < cardCount; ++j) {
                cards.add(buf.readUtf());
            }
            data.reveledCards.put(uuid, cards);
        }
        return data;
    }

    public static RevealedData get(MinecraftServer server) {
        if (server == null) {
            return LOCAL;
        }
        return (RevealedData)server.overworld().getDataStorage().computeIfAbsent(FACTORY, "ArkanyamonRevealedData");
    }
}

