/*
 * Decompiled with CFR 0.152.
 */
package br.com.arkanis.arkanyamon;

import br.com.arkanis.arkanyamon.RevealedData;
import br.com.arkanis.arkanyamon.game.ArkaniaCard;
import br.com.arkanis.arkanyamon.network.RevealedDataPayload;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.Nullable;

public class Command {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"arkanyamon").then(((LiteralArgumentBuilder)Commands.literal((String)"reveal").then(((RequiredArgumentBuilder)Commands.argument((String)"card", (ArgumentType)StringArgumentType.word()).suggests((context, builder) -> Command.suggestCards(builder)).executes(ctx -> Command.revealCard((CommandSourceStack)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"card"), List.of(((CommandSourceStack)ctx.getSource()).getPlayerOrException())))).then(Commands.argument((String)"players", (ArgumentType)EntityArgument.players()).executes(ctx -> Command.revealCard((CommandSourceStack)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"card"), EntityArgument.getPlayers((CommandContext)ctx, (String)"players")))))).then(((LiteralArgumentBuilder)Commands.literal((String)"all").executes(ctx -> Command.revealAllCards((CommandSourceStack)ctx.getSource(), List.of(((CommandSourceStack)ctx.getSource()).getPlayerOrException())))).then(Commands.argument((String)"players", (ArgumentType)EntityArgument.players()).executes(ctx -> Command.revealAllCards((CommandSourceStack)ctx.getSource(), EntityArgument.getPlayers((CommandContext)ctx, (String)"players"))))))).then(((LiteralArgumentBuilder)Commands.literal((String)"hide").then(((RequiredArgumentBuilder)Commands.argument((String)"card", (ArgumentType)StringArgumentType.word()).suggests((context, builder) -> Command.suggestCards(builder)).executes(ctx -> Command.hideCard((CommandSourceStack)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"card"), List.of(((CommandSourceStack)ctx.getSource()).getPlayerOrException())))).then(Commands.argument((String)"players", (ArgumentType)EntityArgument.players()).executes(ctx -> Command.hideCard((CommandSourceStack)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"card"), EntityArgument.getPlayers((CommandContext)ctx, (String)"players")))))).then(((LiteralArgumentBuilder)Commands.literal((String)"all").executes(ctx -> Command.hideAllCards((CommandSourceStack)ctx.getSource(), List.of(((CommandSourceStack)ctx.getSource()).getPlayerOrException())))).then(Commands.argument((String)"players", (ArgumentType)EntityArgument.players()).executes(ctx -> Command.hideAllCards((CommandSourceStack)ctx.getSource(), EntityArgument.getPlayers((CommandContext)ctx, (String)"players"))))))).then(Commands.literal((String)"check").then(((RequiredArgumentBuilder)Commands.argument((String)"card", (ArgumentType)StringArgumentType.word()).suggests((context, builder) -> Command.suggestCards(builder)).executes(ctx -> Command.checkCard((CommandSourceStack)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"card"), List.of(((CommandSourceStack)ctx.getSource()).getPlayerOrException())))).then(Commands.argument((String)"players", (ArgumentType)EntityArgument.players()).executes(ctx -> Command.checkCard((CommandSourceStack)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"card"), EntityArgument.getPlayers((CommandContext)ctx, (String)"players")))))));
    }

    private static CompletableFuture<Suggestions> suggestCards(SuggestionsBuilder builder) {
        for (ArkaniaCard card : ArkaniaCard.values()) {
            builder.suggest(card.name());
        }
        return builder.buildFuture();
    }

    private static int revealCard(CommandSourceStack source, String cardName, Collection<ServerPlayer> players) {
        ArkaniaCard card = Command.getCard(cardName);
        if (card == null) {
            source.sendFailure((Component)Component.literal((String)"[Arkanyamon] Essa carta n\u00e3o existe"));
            return 0;
        }
        RevealedData data = RevealedData.get(source.getServer());
        int count = 0;
        for (ServerPlayer player : players) {
            boolean changed = data.revealCard((Player)player, card);
            if (changed) {
                PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new RevealedDataPayload(data), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
            source.sendSuccess(() -> Component.literal((String)("[Arkanyamon] A carta " + card.name() + " foi revelada para ")).append(player.getDisplayName()).withStyle(ChatFormatting.GREEN), false);
            ++count;
        }
        return count;
    }

    private static int hideCard(CommandSourceStack source, String cardName, Collection<ServerPlayer> players) {
        ArkaniaCard card = Command.getCard(cardName);
        if (card == null) {
            source.sendFailure((Component)Component.literal((String)"[Arkanyamon] Essa carta n\u00e3o existe"));
            return 0;
        }
        RevealedData data = RevealedData.get(source.getServer());
        int count = 0;
        for (ServerPlayer player : players) {
            boolean changed = data.hideCard((Player)player, card);
            if (changed) {
                PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new RevealedDataPayload(data), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
            source.sendSuccess(() -> Component.literal((String)("[Arkanyamon] A carta " + card.name() + " foi escondida para ")).append(player.getDisplayName()).withStyle(ChatFormatting.YELLOW), false);
            ++count;
        }
        return count;
    }

    private static int revealAllCards(CommandSourceStack source, Collection<ServerPlayer> players) {
        RevealedData data = RevealedData.get(source.getServer());
        int count = 0;
        for (ServerPlayer player : players) {
            boolean changed = false;
            for (ArkaniaCard card : ArkaniaCard.values()) {
                changed = data.revealCard((Player)player, card) || changed;
            }
            if (changed) {
                PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new RevealedDataPayload(data), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
            source.sendSuccess(() -> Component.literal((String)"[Arkanyamon] Todas as cartas foram reveladas para ").append(player.getDisplayName()).withStyle(ChatFormatting.GREEN), false);
            ++count;
        }
        return count;
    }

    private static int hideAllCards(CommandSourceStack source, Collection<ServerPlayer> players) {
        RevealedData data = RevealedData.get(source.getServer());
        int count = 0;
        for (ServerPlayer player : players) {
            boolean changed = false;
            for (ArkaniaCard card : ArkaniaCard.values()) {
                changed = data.hideCard((Player)player, card) || changed;
            }
            if (changed) {
                PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new RevealedDataPayload(data), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
            source.sendSuccess(() -> Component.literal((String)"[Arkanyamon] Todas as cartas foram escondidas para ").append(player.getDisplayName()).withStyle(ChatFormatting.YELLOW), false);
            ++count;
        }
        return count;
    }

    private static int checkCard(CommandSourceStack source, String cardName, Collection<ServerPlayer> players) {
        ArkaniaCard card = Command.getCard(cardName);
        if (card == null) {
            source.sendFailure((Component)Component.literal((String)"[Arkanyamon] Essa carta n\u00e3o existe"));
            return 0;
        }
        RevealedData data = RevealedData.get(source.getServer());
        int count = 0;
        for (ServerPlayer player : players) {
            boolean revealed = data.isCardRevealed((Player)player, card);
            source.sendSuccess(() -> Component.literal((String)("[Arkanyamon] A carta " + card.name() + " est\u00e1 " + (revealed ? "revelada" : "escondida") + " para ")).append(player.getDisplayName()).withStyle(ChatFormatting.BLUE), false);
            ++count;
        }
        return count;
    }

    @Nullable
    private static ArkaniaCard getCard(String name) {
        try {
            return ArkaniaCard.values().stream().filter(arkaniaCard -> arkaniaCard.name().equals(name)).findFirst().orElse(null);
        }
        catch (IllegalArgumentException ex) {
            return null;
        }
    }
}

