/*
 * Decompiled with CFR 0.152.
 */
package br.com.arkanis.arkanyamon;

import br.com.arkanis.arkanyamon.LoggerHelper;
import br.com.arkanis.arkanyamon.RevealedData;
import br.com.arkanis.arkanyamon.client.ArkanyamonClient;
import br.com.arkanis.arkanyamon.game.ArkaniaCard;
import br.com.arkanis.arkanyamon.game.ArkaniaGame;
import br.com.arkanis.arkanyamon.item.ModCreativeTabs;
import br.com.arkanis.arkanyamon.item.ModDataComponentTypes;
import br.com.arkanis.arkanyamon.item.ModItems;
import br.com.arkanis.arkanyamon.menu.ModMenus;
import br.com.arkanis.arkanyamon.mixed.ResourceLocationMixed;
import br.com.arkanis.arkanyamon.network.ActionPayload;
import br.com.arkanis.arkanyamon.network.ActivatePayload;
import br.com.arkanis.arkanyamon.network.ChargePayload;
import br.com.arkanis.arkanyamon.network.ContinuePayload;
import br.com.arkanis.arkanyamon.network.OpenPayload;
import br.com.arkanis.arkanyamon.network.RenameDeckBoxPayload;
import br.com.arkanis.arkanyamon.network.RetreatPayload;
import br.com.arkanis.arkanyamon.network.RevealedDataPayload;
import br.com.arkanis.arkanyamon.sound.ModSounds;
import com.mojang.blaze3d.platform.InputConstants;
import dev.lucaargolo.charta.game.CardGames;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.loading.FMLLoader;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;
import net.neoforged.neoforge.server.ServerLifecycleHooks;
import org.jetbrains.annotations.Nullable;

@Mod(value="arkanyamon")
public class Arkanyamon {
    public static final String MOD_ID = "arkanyamon";
    public static final String MOD_NAME = "Arkanyamon";
    public static final LoggerHelper LOGGER = new LoggerHelper("Arkanyamon");
    public static final CardGames.Factory<ArkaniaGame> GAME = CardGames.register((ResourceLocation)Arkanyamon.id("arkanyamon"), ArkaniaGame::new);
    public static ResourceLocation EMPTY = Arkanyamon.id("textures/empty.png");

    public Arkanyamon(IEventBus modEventBus, ModContainer modContainer) {
        ModDataComponentTypes.register(modEventBus);
        ModItems.register(modEventBus);
        ModCreativeTabs.register(modEventBus);
        ModMenus.register(modEventBus);
        ModSounds.register(modEventBus);
    }

    public static ResourceLocation id(String path) {
        ResourceLocation location = ResourceLocation.fromNamespaceAndPath((String)MOD_ID, (String)path);
        ((ResourceLocationMixed)location).arkanyamon$setPrefixBlocked(true);
        return location;
    }

    public static boolean isShiftDown() {
        Supplier<Supplier> client = () -> () -> InputConstants.isKeyDown((long)Minecraft.getInstance().getWindow().getWindow(), (int)340);
        Supplier<Supplier> server = () -> () -> false;
        if (FMLLoader.getDist().isClient()) {
            return (Boolean)client.get().get();
        }
        return (Boolean)server.get().get();
    }

    public static boolean isCardRevealed(ArkaniaCard card) {
        return Arkanyamon.isCardRevealed(null, card);
    }

    public static boolean isCardRevealed(@Nullable Player player, ArkaniaCard card) {
        Supplier<Supplier> client = () -> () -> ArkanyamonClient.isCardRevealed(card);
        Supplier<Supplier> server = () -> () -> RevealedData.get(ServerLifecycleHooks.getCurrentServer()).isCardRevealed(player, card);
        if (FMLLoader.getDist().isClient()) {
            return (Boolean)client.get().get();
        }
        return (Boolean)server.get().get();
    }

    @EventBusSubscriber(modid="arkanyamon", bus=EventBusSubscriber.Bus.MOD)
    public static class ModEvents {
        @SubscribeEvent
        public static void register(RegisterPayloadHandlersEvent event) {
            PayloadRegistrar registrar = event.registrar("1");
            registrar.playToServer(ActionPayload.TYPE, ActionPayload.STREAM_CODEC, ActionPayload::handleServer);
            registrar.playToServer(ActivatePayload.TYPE, ActivatePayload.STREAM_CODEC, ActivatePayload::handleServer);
            registrar.playToServer(ChargePayload.TYPE, ChargePayload.STREAM_CODEC, ChargePayload::handleServer);
            registrar.playToServer(ContinuePayload.TYPE, ContinuePayload.STREAM_CODEC, ContinuePayload::handleServer);
            registrar.playToServer(OpenPayload.TYPE, OpenPayload.STREAM_CODEC, OpenPayload::handleServer);
            registrar.playToServer(RenameDeckBoxPayload.TYPE, RenameDeckBoxPayload.STREAM_CODEC, RenameDeckBoxPayload::handleServer);
            registrar.playToServer(RetreatPayload.TYPE, RetreatPayload.STREAM_CODEC, RetreatPayload::handleServer);
            registrar.playToClient(RevealedDataPayload.TYPE, RevealedDataPayload.STREAM_CODEC, RevealedDataPayload::handleClient);
        }
    }
}

