/*
 * Decompiled with CFR 0.152.
 */
package immersive_melodies.neoforge;

import immersive_melodies.Common;
import immersive_melodies.ItemGroups;
import immersive_melodies.Items;
import immersive_melodies.Sounds;
import immersive_melodies.network.ImmersivePayload;
import immersive_melodies.network.Network;
import java.util.function.Consumer;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.CreativeModeTab;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.common.Mod;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.neoforged.neoforge.registries.RegisterEvent;

@Mod(value="immersive_melodies")
@EventBusSubscriber(modid="immersive_melodies")
public final class CommonNeoForge {
    public static final DeferredRegister<CreativeModeTab> DEF_REG = DeferredRegister.create((ResourceKey)Registries.CREATIVE_MODE_TAB, (String)"immersive_melodies");
    public static final DeferredHolder<CreativeModeTab, CreativeModeTab> TAB = DEF_REG.register("immersive_melodies", () -> CreativeModeTab.builder().title(ItemGroups.getDisplayName()).icon(ItemGroups::getIcon).displayItems((featureFlags, output) -> output.acceptAll(Items.getSortedItems())).build());

    private static <T> void registerHelper(RegisterEvent event, Registry<T> register, Consumer<Common.RegisterHelper<T>> consumer) {
        event.register(register.key(), registry -> consumer.accept((arg_0, arg_1) -> ((RegisterEvent.RegisterHelper)registry).register(arg_0, arg_1)));
    }

    public CommonNeoForge(IEventBus bus) {
        DEF_REG.register(bus);
    }

    @SubscribeEvent
    public static void register(RegisterEvent event) {
        CommonNeoForge.registerHelper(event, BuiltInRegistries.ITEM, Items::registerItems);
        CommonNeoForge.registerHelper(event, BuiltInRegistries.SOUND_EVENT, Sounds::registerSounds);
    }

    @SubscribeEvent
    public static void registerNetwork(RegisterPayloadHandlersEvent event) {
        Network.register(new NeoForgeRegistrar(event.registrar("1")));
        Network.registerSender((x$0, x$1) -> PacketDistributor.sendToPlayer((ServerPlayer)x$0, (CustomPacketPayload)x$1, (CustomPacketPayload[])new CustomPacketPayload[0]));
        Network.registerClientSender(x$0 -> PacketDistributor.sendToServer((CustomPacketPayload)x$0, (CustomPacketPayload[])new CustomPacketPayload[0]));
    }

    static class NeoForgeRegistrar
    implements Network.Registrar {
        PayloadRegistrar registrar;

        public NeoForgeRegistrar(PayloadRegistrar registrar) {
            this.registrar = registrar;
        }

        @Override
        public <T extends ImmersivePayload> void register(CustomPacketPayload.Type<T> type, StreamCodec<FriendlyByteBuf, T> codec, boolean isServer) {
            if (isServer) {
                this.registrar.playToServer(type, codec, (payload, ctx) -> ctx.enqueueWork(() -> payload.handle(ctx.player())));
            } else {
                this.registrar.playToClient(type, codec, (payload, ctx) -> ctx.enqueueWork(() -> payload.handle(ctx.player())));
            }
        }
    }
}

