/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.herbalbrews.core.blocks;

import java.util.List;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextColor;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.satisfy.herbalbrews.core.blocks.entity.JugBlockEntity;
import net.satisfy.herbalbrews.core.items.DrinkBlockItem;
import net.satisfy.herbalbrews.platform.PlatformHelper;
import org.jetbrains.annotations.NotNull;

public class JugBlock
extends Block
implements EntityBlock {
    public static final DirectionProperty FACING = BlockStateProperties.HORIZONTAL_FACING;
    public static final IntegerProperty FILL_STAGE = IntegerProperty.create((String)"fill_stage", (int)0, (int)3);
    private static final VoxelShape SHAPE = Shapes.box((double)0.1875, (double)0.0, (double)0.1875, (double)0.8125, (double)0.875, (double)0.8125);

    public JugBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)FILL_STAGE, (Comparable)Integer.valueOf(0)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, FILL_STAGE});
    }

    @NotNull
    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        return (BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)ctx.getHorizontalDirection().getOpposite())).setValue((Property)FILL_STAGE, (Comparable)Integer.valueOf(0));
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new JugBlockEntity(pos, state);
    }

    protected ItemInteractionResult useItemOn(ItemStack itemStack, BlockState blockState, Level level, BlockPos blockPos, Player player, InteractionHand interactionHand, BlockHitResult blockHitResult) {
        if (level.isClientSide) {
            return ItemInteractionResult.SUCCESS;
        }
        ItemStack heldItem = player.getItemInHand(interactionHand);
        BlockEntity blockEntity = level.getBlockEntity(blockPos);
        if (!(blockEntity instanceof JugBlockEntity)) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        JugBlockEntity jug = (JugBlockEntity)blockEntity;
        if (heldItem.getItem() instanceof DrinkBlockItem) {
            if (jug.getDrinks().size() < 3) {
                ItemStack drinkToAdd = heldItem.copy();
                drinkToAdd.setCount(1);
                jug.addDrink(drinkToAdd);
                heldItem.shrink(1);
                int fillStage = jug.getDrinks().size();
                level.setBlock(blockPos, (BlockState)blockState.setValue((Property)FILL_STAGE, (Comparable)Integer.valueOf(fillStage)), 3);
                level.playSound(null, blockPos, SoundEvents.BOTTLE_FILL, SoundSource.BLOCKS, 1.0f, 1.0f);
                return ItemInteractionResult.SUCCESS;
            }
            return ItemInteractionResult.FAIL;
        }
        if (!jug.getDrinks().isEmpty()) {
            int duration = PlatformHelper.getJugEffectDuration();
            jug.applyEffects((LivingEntity)player, duration);
            jug.clearDrinks();
            level.setBlock(blockPos, (BlockState)blockState.setValue((Property)FILL_STAGE, (Comparable)Integer.valueOf(0)), 3);
            level.playSound(null, blockPos, SoundEvents.HONEY_DRINK, SoundSource.BLOCKS, 1.0f, 1.0f);
            return ItemInteractionResult.SUCCESS;
        }
        return ItemInteractionResult.FAIL;
    }

    public void appendHoverText(ItemStack itemStack, Item.TooltipContext tooltipContext, List<Component> tooltip, TooltipFlag tooltipFlag) {
        if (Screen.hasShiftDown()) {
            tooltip.add((Component)Component.translatable((String)"tooltip.herbalbrews.description.title").withStyle(style -> style.withColor(TextColor.fromRgb((int)5025616)).withBold(Boolean.valueOf(true))));
            tooltip.add((Component)Component.translatable((String)"tooltip.herbalbrews.description.jug_1").withStyle(style -> style.withColor(TextColor.fromRgb((int)5025616)).withItalic(Boolean.valueOf(false))));
            tooltip.add((Component)Component.empty());
            tooltip.add((Component)Component.translatable((String)"tooltip.herbalbrews.description.jug_2").withStyle(style -> style.withColor(TextColor.fromRgb((int)5025616)).withItalic(Boolean.valueOf(false))));
        } else {
            tooltip.add((Component)Component.translatable((String)"tooltip.herbalbrews.canbeplaced").withStyle(style -> style.withColor(TextColor.fromRgb((int)13467442)).withItalic(Boolean.valueOf(true))));
        }
    }

    public void onRemove(BlockState state, Level world, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!state.is(newState.getBlock())) {
            BlockEntity blockEntity = world.getBlockEntity(pos);
            if (blockEntity instanceof JugBlockEntity) {
                JugBlockEntity jug = (JugBlockEntity)blockEntity;
                for (ItemStack drink : jug.getDrinks()) {
                    Containers.dropItemStack((Level)world, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), (ItemStack)drink);
                }
            }
            super.onRemove(state, world, pos, newState, isMoving);
        }
    }
}

