/*
 * Decompiled with CFR 0.152.
 */
package dev.doublekekse.zipline.compat.superposition;

import dev.doublekekse.zipline.Cable;
import java.util.List;
import net.minecraft.class_243;
import net.minecraft.class_3532;
import org.modogthedev.superposition.system.cable.rope_system.RopeNode;
import org.modogthedev.superposition.util.CatmulRomSpline;

public record SuperpositionCable(org.modogthedev.superposition.system.cable.Cable cable) implements Cable
{
    @Override
    public double getProgress(class_243 playerPos) {
        List points = this.cable.getPoints();
        int size = points.size();
        if (size == 0) {
            return 0.0;
        }
        int closestIndex = -1;
        double closestDistance = Double.MAX_VALUE;
        for (int i = 0; i < size; ++i) {
            RopeNode point = (RopeNode)points.get(i);
            double dist = point.getPosition().method_1025(playerPos);
            if (!(dist < closestDistance)) continue;
            closestDistance = dist;
            closestIndex = i;
        }
        double t = (double)closestIndex / (double)(size - 1);
        t = class_3532.method_15350((double)t, (double)0.0, (double)1.0);
        return t;
    }

    @Override
    public boolean isValid() {
        return this.cable.getPoints().size() >= 2;
    }

    @Override
    public class_243 getPoint(double progress) {
        assert (progress >= 0.0 && progress <= 1.0);
        List points = this.cable.getPoints();
        List spline = CatmulRomSpline.generateSpline(points.stream().map(RopeNode::getPosition).toList(), (int)4);
        return (class_243)spline.get((int)(Math.clamp(progress, 0.0, 1.0) * (double)(spline.size() - 1)));
    }

    @Override
    public class_243 getClosestPoint(class_243 pos) {
        double t = this.getProgress(pos);
        return this.getPoint(t);
    }

    @Override
    public class_243 direction(double progress) {
        assert (progress >= 0.0 && progress <= 1.0);
        List points = this.cable.getPoints();
        int index = (int)(Math.clamp(progress, 0.0, 1.0) * (double)(points.size() - 1));
        if (index == 0) {
            ++index;
        }
        return ((RopeNode)points.get(index)).getPosition().method_1020(((RopeNode)points.get(index - 1)).getPosition()).method_1029();
    }

    @Override
    public double length() {
        return this.cable.calculateLength();
    }
}

