/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories.menu;

import io.wispforest.accessories.compat.config.ScreenType;
import io.wispforest.accessories.menu.AccessoriesMenuTypes;
import io.wispforest.accessories.menu.variants.AccessoriesExperimentalMenu;
import io.wispforest.accessories.menu.variants.AccessoriesMenu;
import io.wispforest.accessories.menu.variants.AccessoriesMenuBase;
import java.util.function.Supplier;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public enum AccessoriesMenuVariant {
    ORIGINAL(() -> AccessoriesMenuTypes.ORIGINAL_MENU),
    EXPERIMENTAL_V1(() -> AccessoriesMenuTypes.EXPERIMENTAL_MENU);

    public final Supplier<MenuType<? extends AccessoriesMenuBase>> supplier;

    private AccessoriesMenuVariant(Supplier<MenuType<? extends AccessoriesMenuBase>> supplier) {
        this.supplier = supplier;
    }

    @Nullable
    public static AccessoriesMenuVariant getVariant(ScreenType screenType) {
        return switch (screenType) {
            case ScreenType.ORIGINAL -> ORIGINAL;
            case ScreenType.EXPERIMENTAL_V1 -> EXPERIMENTAL_V1;
            default -> null;
        };
    }

    public static AccessoriesMenuVariant getVariant(MenuType<? extends AccessoriesMenuBase> menuType) {
        for (AccessoriesMenuVariant value : AccessoriesMenuVariant.values()) {
            if (!value.supplier.get().equals(menuType)) continue;
            return value;
        }
        throw new IllegalArgumentException("Unknown MenuType passed to get Accessories Menu Variant! [Type: " + String.valueOf(BuiltInRegistries.MENU.getKey(menuType)) + "]");
    }

    public static AbstractContainerMenu openMenu(int i, Inventory inv, AccessoriesMenuVariant variant, @Nullable LivingEntity target, @Nullable ItemStack carriedStack) {
        AccessoriesMenuBase menu = switch (variant.ordinal()) {
            case 1 -> new AccessoriesExperimentalMenu(i, inv, target);
            case 0 -> new AccessoriesMenu(i, inv, target);
            default -> throw new IllegalArgumentException("Unknown AccessoriesMenuVariant passed to construct Menu! [Variant: " + variant.name() + "]");
        };
        if (carriedStack != null) {
            menu.setCarried(carriedStack);
        }
        return menu;
    }
}

