/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories.data;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.logging.LogUtils;
import io.wispforest.accessories.AccessoriesInternals;
import io.wispforest.accessories.api.slot.SlotGroup;
import io.wispforest.accessories.api.slot.SlotType;
import io.wispforest.accessories.api.slot.UniqueSlotHandling;
import io.wispforest.accessories.data.EntitySlotLoader;
import io.wispforest.accessories.data.ReplaceableJsonResourceReloadListener;
import io.wispforest.accessories.data.SlotTypeLoader;
import io.wispforest.accessories.impl.SlotGroupImpl;
import io.wispforest.accessories.utils.CollectionUtils;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.SequencedMap;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.ApiStatus;
import org.slf4j.Logger;

public class SlotGroupLoader
extends ReplaceableJsonResourceReloadListener {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().setLenient().create();
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final SlotGroupLoader INSTANCE = new SlotGroupLoader();
    private SequencedMap<String, SlotGroup> server = new LinkedHashMap<String, SlotGroup>();
    private SequencedMap<String, SlotGroup> client = new LinkedHashMap<String, SlotGroup>();

    protected SlotGroupLoader() {
        super(GSON, LOGGER, "accessories/group");
    }

    public static List<SlotGroup> getGroups(Level level) {
        return INSTANCE.getGroups(level.isClientSide(), true);
    }

    public static List<SlotGroup> getGroups(Level level, boolean filterUniqueGroups) {
        return INSTANCE.getGroups(level.isClientSide(), filterUniqueGroups);
    }

    public static Map<SlotGroup, List<SlotType>> getValidGroups(LivingEntity living) {
        Map<String, SlotType> entitySpecificSlots = EntitySlotLoader.getEntitySlots(living);
        List<SlotGroup> groups = SlotGroupLoader.getGroups(living.level(), false);
        return groups.stream().map(slotGroup -> {
            if (UniqueSlotHandling.isUniqueGroup(slotGroup.name(), living.level().isClientSide())) {
                return null;
            }
            List<SlotType> slots = slotGroup.slots().stream().filter(entitySpecificSlots::containsKey).map(slot -> SlotTypeLoader.getSlotType(living.level(), slot)).toList();
            return slots.isEmpty() ? null : Map.entry(slotGroup, slots);
        }).filter(Objects::nonNull).collect(CollectionUtils.toLinkedMap());
    }

    public static Optional<SlotGroup> getGroup(Level level, String group) {
        return Optional.ofNullable(INSTANCE.getGroup(level.isClientSide(), group));
    }

    @ApiStatus.Internal
    public final Map<String, SlotGroup> getGroupMap(boolean isClientSide) {
        return isClientSide ? this.client : this.server;
    }

    public final List<SlotGroup> getGroups(boolean isClientSide, boolean filterUniqueGroups) {
        Collection<SlotGroup> groups = this.getGroupMap(isClientSide).values();
        if (filterUniqueGroups) {
            groups = groups.stream().filter(group -> !UniqueSlotHandling.isUniqueGroup(group.name(), isClientSide)).toList();
        }
        return List.copyOf(groups);
    }

    public final SlotGroup getGroup(boolean isClientSide, String group) {
        return this.getGroupMap(isClientSide).get(group);
    }

    public final Optional<SlotGroup> findGroup(boolean isClientSide, String slot) {
        for (SlotGroup entry : this.getGroups(isClientSide, false)) {
            if (!entry.slots().contains(slot)) continue;
            return Optional.of(entry);
        }
        return Optional.empty();
    }

    public final SlotGroup getOrDefaultGroup(boolean isClientSide, String slot) {
        Map<String, SlotGroup> groups = this.getGroupMap(isClientSide);
        for (SlotGroup entry : groups.values()) {
            if (!entry.slots().contains(slot)) continue;
            return entry;
        }
        return groups.get("any");
    }

    @ApiStatus.Internal
    public final void setGroups(SequencedMap<String, SlotGroup> groups) {
        this.client = Collections.unmodifiableSequencedMap(groups);
    }

    protected void apply(Map<ResourceLocation, JsonObject> data, ResourceManager resourceManager, ProfilerFiller profiler) {
        HashMap<String, SlotGroupBuilder> slotGroups = new HashMap<String, SlotGroupBuilder>();
        slotGroups.put("unsorted", new SlotGroupBuilder("unsorted").order(30));
        HashMap<String, SlotType> allSlots = new HashMap<String, SlotType>(SlotTypeLoader.INSTANCE.getSlotTypes(false));
        for (Map.Entry<ResourceLocation, JsonObject> entry : data.entrySet()) {
            String icon;
            ResourceLocation location = entry.getKey();
            JsonObject jsonObject = entry.getValue();
            if (!AccessoriesInternals.isValidOnConditions(jsonObject, this.directory, location, null)) continue;
            String[] pathParts = location.getPath().split("/");
            Object groupName = pathParts[pathParts.length - 1];
            Object namespace = pathParts.length > 1 ? pathParts[0] + ":" : "";
            boolean isShared = ((String)namespace).isBlank();
            if (!isShared) {
                groupName = (String)namespace + ":" + (String)groupName;
            }
            SlotGroupBuilder group = slotGroups.computeIfAbsent((String)groupName, SlotGroupBuilder::new);
            if (isShared) {
                JsonArray slotElements = this.safeHelper(GsonHelper::getAsJsonArray, jsonObject, "slots", new JsonArray(), location);
                this.decodeJsonArray(slotElements, "slot", location, JsonElement::getAsString, s -> {
                    for (Map.Entry builderEntry : slotGroups.entrySet()) {
                        if (!((SlotGroupBuilder)builderEntry.getValue()).slots.contains(s)) continue;
                        LOGGER.error("Unable to assign a give slot [{}] to the group [{}] as it already exists within the group [{}]", new Object[]{s, group, builderEntry.getKey()});
                        return;
                    }
                    SlotType slotType = (SlotType)allSlots.remove(s);
                    if (slotType == null) {
                        LOGGER.warn("SlotType added to a given group without being in the main map for slots! [Name: {}]", s);
                    } else {
                        group.addSlot(slotType);
                    }
                });
                group.order(this.safeHelper(GsonHelper::getAsInt, jsonObject, "order", 100, location));
            }
            if ((icon = this.safeHelper(GsonHelper::getAsString, jsonObject, "icon", location)) == null) continue;
            ResourceLocation iconLocation = ResourceLocation.tryParse((String)icon);
            if (iconLocation != null) {
                group.icon(iconLocation);
                continue;
            }
            LOGGER.warn("A given SlotGroup was found to have a invalid Icon Location. [Location: {}]", (Object)location);
        }
        HashSet<SlotType> remainSlots = new HashSet<SlotType>();
        for (SlotType value : allSlots.values()) {
            String slotName = value.name();
            if (!UniqueSlotHandling.isUniqueSlot(slotName)) {
                remainSlots.add(value);
                continue;
            }
            String group = slotName.split(":")[0];
            slotGroups.computeIfAbsent(group, SlotGroupBuilder::new).order(5).addSlot(value);
            UniqueSlotHandling.addGroup(group);
        }
        ((SlotGroupBuilder)slotGroups.get("unsorted")).addSlots(remainSlots);
        HashMap hashMap = new HashMap();
        slotGroups.forEach((s, builder) -> tempMap.put(s, builder.build()));
        this.server = Collections.unmodifiableSequencedMap(hashMap.entrySet().stream().sorted(Map.Entry.comparingByValue().reversed()).collect(CollectionUtils.toLinkedMap()));
    }

    public static class SlotGroupBuilder {
        private final String name;
        private Integer order = null;
        private final Set<SlotType> slots = new HashSet<SlotType>();
        private ResourceLocation iconLocation = SlotGroup.UNKNOWN;

        public SlotGroupBuilder(String name) {
            this.name = name;
        }

        public SlotGroupBuilder order(Integer value) {
            this.order = value;
            return this;
        }

        public SlotGroupBuilder addSlot(SlotType value) {
            this.slots.add(value);
            return this;
        }

        public SlotGroupBuilder addSlots(Collection<SlotType> values) {
            this.slots.addAll(values);
            return this;
        }

        public SlotGroupBuilder icon(ResourceLocation location) {
            this.iconLocation = location;
            return this;
        }

        public SlotGroup build() {
            return new SlotGroupImpl(this.name, Optional.ofNullable(this.order).orElse(0), this.slots.stream().sorted(Comparator.naturalOrder().reversed()).map(SlotType::name).collect(Collectors.toCollection(LinkedHashSet::new)), this.iconLocation);
        }
    }
}

