/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories.api.data.providers.slot;

import com.google.common.collect.Sets;
import com.mojang.serialization.Codec;
import io.wispforest.accessories.api.data.providers.BaseDataProvider;
import io.wispforest.accessories.api.data.providers.slot.RawSlotType;
import io.wispforest.accessories.api.data.providers.slot.SlotBuilder;
import io.wispforest.owo.serialization.CodecUtils;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;

public abstract class SlotDataProvider
extends BaseDataProvider<SlotOutput> {
    private final Codec<RawSlotType> CODEC = CodecUtils.toCodec(RawSlotType.ENDEC);

    public SlotDataProvider(PackOutput packOutput, CompletableFuture<HolderLookup.Provider> completableFuture) {
        super(packOutput, completableFuture);
    }

    @Override
    protected abstract void buildData(HolderLookup.Provider var1, SlotOutput var2);

    public SlotBuilder builder(ResourceLocation uniqueLocation) {
        return this.builder(uniqueLocation.toString());
    }

    public SlotBuilder builder(String slotName) {
        return new SlotBuilder(slotName, false);
    }

    @Override
    public final String getName() {
        return "SlotType";
    }

    @Override
    protected final String type() {
        return "accessories/slot";
    }

    @Override
    protected final PackOutput.Target target() {
        return PackOutput.Target.DATA_PACK;
    }

    @Override
    protected final SlotOutput buildOutput(final CachedOutput cachedOutput, final HolderLookup.Provider provider) {
        return new SlotOutput(){
            final Set<ResourceLocation> set = Sets.newHashSet();
            final List<CompletableFuture<?>> list = new ArrayList();

            @Override
            public void accept(String namespace, RawSlotType rawSlotType) {
                ResourceLocation location = ResourceLocation.fromNamespaceAndPath((String)namespace, (String)rawSlotType.name().replace(":", "/"));
                if (!this.set.add(location)) {
                    throw new IllegalStateException("Duplicate SlotType: " + String.valueOf(location));
                }
                this.list.add(DataProvider.saveStable((CachedOutput)cachedOutput, (HolderLookup.Provider)provider, SlotDataProvider.this.CODEC, (Object)rawSlotType, (Path)SlotDataProvider.this.pathProvider().json(location)));
            }

            @Override
            public Collection<CompletableFuture<?>> futures() {
                return this.list;
            }
        };
    }

    public static interface SlotOutput
    extends BaseDataProvider.DataOutput {
        public void accept(String var1, RawSlotType var2);
    }
}

