/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.luminousbeasts.entity;

import net.mcreator.luminousbeasts.init.LuminousBeastsModEntities;
import net.mcreator.luminousbeasts.procedures.HermitKing1HurtProcedure;
import net.mcreator.luminousbeasts.procedures.HermitKing1TickProcedure;
import net.mcreator.luminousbeasts.procedures.HermitKingEntityDiesProcedure;
import net.mcreator.luminousbeasts.procedures.HermitKingLook1Procedure;
import net.mcreator.luminousbeasts.procedures.HermitKingSpawningProcedure;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnPlacementTypes;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.neoforged.neoforge.event.entity.RegisterSpawnPlacementsEvent;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class HermitKingEntity
extends Monster
implements GeoEntity {
    public static final EntityDataAccessor<Boolean> SHOOT = SynchedEntityData.defineId(HermitKingEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final EntityDataAccessor<String> ANIMATION = SynchedEntityData.defineId(HermitKingEntity.class, (EntityDataSerializer)EntityDataSerializers.STRING);
    public static final EntityDataAccessor<String> TEXTURE = SynchedEntityData.defineId(HermitKingEntity.class, (EntityDataSerializer)EntityDataSerializers.STRING);
    public static final EntityDataAccessor<Boolean> DATA_JustAttacked = SynchedEntityData.defineId(HermitKingEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final EntityDataAccessor<Boolean> DATA_HalfHealth = SynchedEntityData.defineId(HermitKingEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final EntityDataAccessor<Integer> DATA_counter = SynchedEntityData.defineId(HermitKingEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Boolean> DATA_stop = SynchedEntityData.defineId(HermitKingEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final EntityDataAccessor<Boolean> DATA_IsHiding = SynchedEntityData.defineId(HermitKingEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private boolean swinging;
    private boolean lastloop;
    private long lastSwing;
    public String animationprocedure = "empty";
    String prevAnim = "empty";

    public HermitKingEntity(EntityType<HermitKingEntity> type, Level world) {
        super(type, world);
        this.xpReward = 40;
        this.setNoAi(false);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(SHOOT, (Object)false);
        builder.define(ANIMATION, (Object)"undefined");
        builder.define(TEXTURE, (Object)"hermitking");
        builder.define(DATA_JustAttacked, (Object)false);
        builder.define(DATA_HalfHealth, (Object)false);
        builder.define(DATA_counter, (Object)0);
        builder.define(DATA_stop, (Object)false);
        builder.define(DATA_IsHiding, (Object)false);
    }

    public void setTexture(String texture) {
        this.entityData.set(TEXTURE, (Object)texture);
    }

    public String getTexture() {
        return (String)this.entityData.get(TEXTURE);
    }

    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(1, (Goal)new MeleeAttackGoal(this, (PathfinderMob)this, 1.2, true){

            protected boolean canPerformAttack(LivingEntity entity) {
                return this.isTimeToAttack() && this.mob.distanceToSqr((Entity)entity) < 4.0 && this.mob.getSensing().hasLineOfSight((Entity)entity);
            }
        });
        this.targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, false, false){

            public boolean canUse() {
                double x = HermitKingEntity.this.getX();
                double y = HermitKingEntity.this.getY();
                double z = HermitKingEntity.this.getZ();
                HermitKingEntity entity = HermitKingEntity.this;
                Level world = HermitKingEntity.this.level();
                return super.canUse() && HermitKingLook1Procedure.execute((Entity)entity);
            }

            public boolean canContinueToUse() {
                double x = HermitKingEntity.this.getX();
                double y = HermitKingEntity.this.getY();
                double z = HermitKingEntity.this.getZ();
                HermitKingEntity entity = HermitKingEntity.this;
                Level world = HermitKingEntity.this.level();
                return super.canContinueToUse() && HermitKingLook1Procedure.execute((Entity)entity);
            }
        });
        this.targetSelector.addGoal(3, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]){

            public boolean canUse() {
                double x = HermitKingEntity.this.getX();
                double y = HermitKingEntity.this.getY();
                double z = HermitKingEntity.this.getZ();
                HermitKingEntity entity = HermitKingEntity.this;
                Level world = HermitKingEntity.this.level();
                return super.canUse() && HermitKingLook1Procedure.execute((Entity)entity);
            }

            public boolean canContinueToUse() {
                double x = HermitKingEntity.this.getX();
                double y = HermitKingEntity.this.getY();
                double z = HermitKingEntity.this.getZ();
                HermitKingEntity entity = HermitKingEntity.this;
                Level world = HermitKingEntity.this.level();
                return super.canContinueToUse() && HermitKingLook1Procedure.execute((Entity)entity);
            }
        });
        this.goalSelector.addGoal(4, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.8){

            public boolean canUse() {
                double x = HermitKingEntity.this.getX();
                double y = HermitKingEntity.this.getY();
                double z = HermitKingEntity.this.getZ();
                HermitKingEntity entity = HermitKingEntity.this;
                Level world = HermitKingEntity.this.level();
                return super.canUse() && HermitKingLook1Procedure.execute((Entity)entity);
            }

            public boolean canContinueToUse() {
                double x = HermitKingEntity.this.getX();
                double y = HermitKingEntity.this.getY();
                double z = HermitKingEntity.this.getZ();
                HermitKingEntity entity = HermitKingEntity.this;
                Level world = HermitKingEntity.this.level();
                return super.canContinueToUse() && HermitKingLook1Procedure.execute((Entity)entity);
            }
        });
        this.goalSelector.addGoal(5, (Goal)new RandomLookAroundGoal((Mob)this){

            public boolean canUse() {
                double x = HermitKingEntity.this.getX();
                double y = HermitKingEntity.this.getY();
                double z = HermitKingEntity.this.getZ();
                HermitKingEntity entity = HermitKingEntity.this;
                Level world = HermitKingEntity.this.level();
                return super.canUse() && HermitKingLook1Procedure.execute((Entity)entity);
            }

            public boolean canContinueToUse() {
                double x = HermitKingEntity.this.getX();
                double y = HermitKingEntity.this.getY();
                double z = HermitKingEntity.this.getZ();
                HermitKingEntity entity = HermitKingEntity.this;
                Level world = HermitKingEntity.this.level();
                return super.canContinueToUse() && HermitKingLook1Procedure.execute((Entity)entity);
            }
        });
        this.goalSelector.addGoal(6, (Goal)new FloatGoal((Mob)this));
    }

    public void playStepSound(BlockPos pos, BlockState blockIn) {
        this.playSound((SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"block.sand.step")), 0.15f, 1.0f);
    }

    public SoundEvent getHurtSound(DamageSource ds) {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"entity.generic.hurt"));
    }

    public SoundEvent getDeathSound() {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"entity.generic.death"));
    }

    public boolean hurt(DamageSource source, float amount) {
        HermitKing1HurtProcedure.execute((LevelAccessor)this.level(), this.getX(), this.getY(), this.getZ(), (Entity)this);
        Entity immediatesourceentity = source.getDirectEntity();
        return super.hurt(source, amount);
    }

    public void die(DamageSource source) {
        super.die(source);
        HermitKingEntityDiesProcedure.execute((LevelAccessor)this.level(), (Entity)this, source.getEntity());
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putString("Texture", this.getTexture());
        compound.putBoolean("DataJustAttacked", ((Boolean)this.entityData.get(DATA_JustAttacked)).booleanValue());
        compound.putBoolean("DataHalfHealth", ((Boolean)this.entityData.get(DATA_HalfHealth)).booleanValue());
        compound.putInt("Datacounter", ((Integer)this.entityData.get(DATA_counter)).intValue());
        compound.putBoolean("Datastop", ((Boolean)this.entityData.get(DATA_stop)).booleanValue());
        compound.putBoolean("DataIsHiding", ((Boolean)this.entityData.get(DATA_IsHiding)).booleanValue());
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        if (compound.contains("Texture")) {
            this.setTexture(compound.getString("Texture"));
        }
        if (compound.contains("DataJustAttacked")) {
            this.entityData.set(DATA_JustAttacked, (Object)compound.getBoolean("DataJustAttacked"));
        }
        if (compound.contains("DataHalfHealth")) {
            this.entityData.set(DATA_HalfHealth, (Object)compound.getBoolean("DataHalfHealth"));
        }
        if (compound.contains("Datacounter")) {
            this.entityData.set(DATA_counter, (Object)compound.getInt("Datacounter"));
        }
        if (compound.contains("Datastop")) {
            this.entityData.set(DATA_stop, (Object)compound.getBoolean("Datastop"));
        }
        if (compound.contains("DataIsHiding")) {
            this.entityData.set(DATA_IsHiding, (Object)compound.getBoolean("DataIsHiding"));
        }
    }

    public void baseTick() {
        super.baseTick();
        HermitKing1TickProcedure.execute((LevelAccessor)this.level(), (Entity)this);
        this.refreshDimensions();
    }

    public EntityDimensions getDefaultDimensions(Pose pose) {
        return super.getDefaultDimensions(pose).scale(1.0f);
    }

    public static void init(RegisterSpawnPlacementsEvent event) {
        event.register((EntityType)LuminousBeastsModEntities.HERMIT_KING.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, (entityType, world, reason, pos, random) -> {
            int x = pos.getX();
            int y = pos.getY();
            int z = pos.getZ();
            return HermitKingSpawningProcedure.execute((LevelAccessor)world, x, y, z);
        }, RegisterSpawnPlacementsEvent.Operation.REPLACE);
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.createMobAttributes();
        builder = builder.add(Attributes.MOVEMENT_SPEED, 0.27);
        builder = builder.add(Attributes.MAX_HEALTH, 170.0);
        builder = builder.add(Attributes.ARMOR, 15.0);
        builder = builder.add(Attributes.ATTACK_DAMAGE, 12.0);
        builder = builder.add(Attributes.FOLLOW_RANGE, 16.0);
        builder = builder.add(Attributes.STEP_HEIGHT, 0.6);
        builder = builder.add(Attributes.KNOCKBACK_RESISTANCE, 1.0);
        builder = builder.add(Attributes.ATTACK_KNOCKBACK, 2.5);
        return builder;
    }

    private PlayState movementPredicate(AnimationState event) {
        if (this.animationprocedure.equals("empty")) {
            if (event.isMoving() || !(event.getLimbSwingAmount() > -0.15f) || !(event.getLimbSwingAmount() < 0.15f)) {
                return event.setAndContinue(RawAnimation.begin().thenLoop("walk"));
            }
            if (this.isDeadOrDying()) {
                return event.setAndContinue(RawAnimation.begin().thenPlay("death"));
            }
            return event.setAndContinue(RawAnimation.begin().thenLoop("idle"));
        }
        return PlayState.STOP;
    }

    private PlayState procedurePredicate(AnimationState event) {
        if (!this.animationprocedure.equals("empty") && event.getController().getAnimationState() == AnimationController.State.STOPPED || !this.animationprocedure.equals(this.prevAnim) && !this.animationprocedure.equals("empty")) {
            if (!this.animationprocedure.equals(this.prevAnim)) {
                event.getController().forceAnimationReset();
            }
            event.getController().setAnimation(RawAnimation.begin().thenPlay(this.animationprocedure));
            if (event.getController().getAnimationState() == AnimationController.State.STOPPED) {
                this.animationprocedure = "empty";
                event.getController().forceAnimationReset();
            }
        } else if (this.animationprocedure.equals("empty")) {
            this.prevAnim = "empty";
            return PlayState.STOP;
        }
        this.prevAnim = this.animationprocedure;
        return PlayState.CONTINUE;
    }

    protected void tickDeath() {
        ++this.deathTime;
        if (this.deathTime == 35) {
            this.remove(Entity.RemovalReason.KILLED);
            this.dropExperience((Entity)this);
        }
    }

    public String getSyncedAnimation() {
        return (String)this.entityData.get(ANIMATION);
    }

    public void setAnimation(String animation) {
        this.entityData.set(ANIMATION, (Object)animation);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar data) {
        data.add(new AnimationController((GeoAnimatable)this, "movement", 0, this::movementPredicate));
        data.add(new AnimationController((GeoAnimatable)this, "procedure", 0, this::procedurePredicate));
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }
}

