/*
 * Decompiled with CFR 0.152.
 */
package com.phantomwing.rusticdelight.event;

import com.phantomwing.rusticdelight.Configuration;
import com.phantomwing.rusticdelight.item.ModItems;
import com.phantomwing.rusticdelight.potions.ModPotions;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.List;
import java.util.Optional;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionBrewing;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.trading.ItemCost;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.level.ItemLike;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.brewing.RegisterBrewingRecipesEvent;
import net.neoforged.neoforge.event.village.VillagerTradesEvent;
import net.neoforged.neoforge.event.village.WandererTradesEvent;

@EventBusSubscriber(modid="rusticdelight")
public class ModEvents {
    public static float PRICE_MULTIPLIER = 0.05f;

    @SubscribeEvent
    public static void addVillagerTrades(VillagerTradesEvent event) {
        if (!((Boolean)Configuration.ENABLE_VILLAGER_TRADES.get()).booleanValue()) {
            return;
        }
        Int2ObjectMap trades = event.getTrades();
        if (event.getType() == VillagerProfession.FARMER) {
            if ((Integer)Configuration.CHANCE_WILD_COTTON.get() > 0) {
                ((List)trades.get(1)).add((trader, random) -> new MerchantOffer(new ItemCost((ItemLike)ModItems.COTTON_BOLL.get(), 24), new ItemStack((ItemLike)Items.EMERALD, 1), 16, 2, PRICE_MULTIPLIER));
            }
            if ((Integer)Configuration.CHANCE_WILD_BELL_PEPPERS.get() > 0) {
                ((List)trades.get(1)).add((trader, random) -> new MerchantOffer(new ItemCost((ItemLike)ModItems.BELL_PEPPER_RED.get(), 24), new ItemStack((ItemLike)Items.EMERALD, 1), 16, 2, PRICE_MULTIPLIER));
            }
            if ((Integer)Configuration.CHANCE_WILD_COFFEE.get() > 0) {
                ((List)trades.get(1)).add((trader, random) -> new MerchantOffer(new ItemCost((ItemLike)ModItems.COFFEE_BEANS.get(), 26), new ItemStack((ItemLike)Items.EMERALD, 1), 16, 2, PRICE_MULTIPLIER));
                ((List)trades.get(5)).add((trader, random) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 3), new ItemStack((ItemLike)ModItems.GOLDEN_COFFEE_BEANS.get(), 3), 12, 30, PRICE_MULTIPLIER));
            }
        } else if (event.getType() == VillagerProfession.FISHERMAN && ((Boolean)Configuration.SQUIDS_DROP_CALAMARI.get()).booleanValue()) {
            ((List)trades.get(1)).add((trader, random) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 1), Optional.of(new ItemCost((ItemLike)ModItems.CALAMARI.get(), 6)), new ItemStack((ItemLike)ModItems.COOKED_CALAMARI.get(), 6), 16, 1, PRICE_MULTIPLIER));
            ((List)trades.get(2)).add((trader, random) -> new MerchantOffer(new ItemCost((ItemLike)ModItems.CALAMARI.get(), 15), new ItemStack((ItemLike)Items.EMERALD, 1), 16, 10, PRICE_MULTIPLIER));
        }
    }

    @SubscribeEvent
    public static void addWanderingTraderTrades(WandererTradesEvent event) {
        if (!((Boolean)Configuration.ENABLE_WANDERING_TRADER_TRADES.get()).booleanValue()) {
            return;
        }
        List genericTrades = event.getGenericTrades();
        if ((Integer)Configuration.CHANCE_WILD_COTTON.get() > 0) {
            genericTrades.add((trader, random) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 1), new ItemStack((ItemLike)ModItems.COTTON_SEEDS.get(), 1), 12, 2, PRICE_MULTIPLIER));
        }
        if ((Integer)Configuration.CHANCE_WILD_BELL_PEPPERS.get() > 0) {
            genericTrades.add((trader, random) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 1), new ItemStack((ItemLike)ModItems.BELL_PEPPER_SEEDS.get(), 1), 12, 2, PRICE_MULTIPLIER));
        }
        if ((Integer)Configuration.CHANCE_WILD_COFFEE.get() > 0) {
            genericTrades.add((trader, random) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 1), new ItemStack((ItemLike)ModItems.COFFEE_BEANS.get(), 1), 12, 2, PRICE_MULTIPLIER));
        }
    }

    @SubscribeEvent
    public static void registerBrewingRecipes(RegisterBrewingRecipesEvent event) {
        if (!((Boolean)Configuration.ENABLE_POTIONS.get()).booleanValue()) {
            return;
        }
        PotionBrewing.Builder builder = event.getBuilder();
        if ((Integer)Configuration.CHANCE_WILD_COFFEE.get() > 0) {
            builder.addMix(Potions.AWKWARD, (Item)ModItems.GOLDEN_COFFEE_BEANS.get(), ModPotions.HASTE_POTION);
            builder.addMix(ModPotions.HASTE_POTION, Items.REDSTONE, ModPotions.LONG_HASTE_POTION);
            builder.addMix(ModPotions.HASTE_POTION, Items.GLOWSTONE_DUST, ModPotions.STRONG_HASTE_POTION);
        }
    }
}

