/*
 * Decompiled with CFR 0.152.
 */
package tech.alexnijjar.golemoverhaul.mixins.common;

import com.mojang.datafixers.util.Either;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.pools.SinglePoolElement;
import net.minecraft.world.level.levelgen.structure.templatesystem.LiquidSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import tech.alexnijjar.golemoverhaul.common.entities.golems.BarrelGolem;
import tech.alexnijjar.golemoverhaul.common.entities.golems.HayGolem;
import tech.alexnijjar.golemoverhaul.common.entities.golems.base.BaseGolem;
import tech.alexnijjar.golemoverhaul.common.registry.ModEntityTypes;

@Mixin(value={SinglePoolElement.class})
public abstract class SinglePoolElementMixin {
    @Unique
    private static final ResourceLocation golemoverhaul$IRON_GOLEM_STRUCTURE = ResourceLocation.withDefaultNamespace((String)"village/common/iron_golem");
    @Shadow
    @Final
    protected Either<ResourceLocation, StructureTemplate> template;

    @Shadow
    protected abstract StructurePlaceSettings getSettings(Rotation var1, BoundingBox var2, LiquidSettings var3, boolean var4);

    @Inject(method={"place(Lnet/minecraft/world/level/levelgen/structure/templatesystem/StructureTemplateManager;Lnet/minecraft/world/level/WorldGenLevel;Lnet/minecraft/world/level/StructureManager;Lnet/minecraft/world/level/chunk/ChunkGenerator;Lnet/minecraft/core/BlockPos;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/Rotation;Lnet/minecraft/world/level/levelgen/structure/BoundingBox;Lnet/minecraft/util/RandomSource;Lnet/minecraft/world/level/levelgen/structure/templatesystem/LiquidSettings;Z)Z"}, at={@At(value="RETURN")})
    private void golemoverhaul$place(StructureTemplateManager structureTemplateManager, WorldGenLevel worldGenLevel, StructureManager structureManager, ChunkGenerator generator, BlockPos offset, BlockPos pos, Rotation rotation, BoundingBox box, RandomSource random, LiquidSettings liquidSettings, boolean keepJigsaws, CallbackInfoReturnable<Boolean> cir) {
        if (!((Boolean)cir.getReturnValue()).booleanValue()) {
            return;
        }
        if (worldGenLevel.isClientSide()) {
            return;
        }
        this.template.left().ifPresent(templateLocation -> {
            EntityType hayGolemEntityType;
            if (!templateLocation.equals((Object)golemoverhaul$IRON_GOLEM_STRUCTURE)) {
                return;
            }
            StructurePlaceSettings settings = this.getSettings(rotation, box, liquidSettings, keepJigsaws);
            EntityType barrelGolemEntityType = (EntityType)ModEntityTypes.BARREL_GOLEM.get();
            if (BarrelGolem.checkMobSpawnRules((EntityType<? extends Mob>)barrelGolemEntityType, (LevelAccessor)worldGenLevel, MobSpawnType.SPAWNER, offset, worldGenLevel.getRandom())) {
                this.golemoverhaul$spawnAdditionalGolem(barrelGolemEntityType, worldGenLevel, settings, offset);
            }
            if (HayGolem.checkMobSpawnRules((EntityType<? extends Mob>)(hayGolemEntityType = (EntityType)ModEntityTypes.HAY_GOLEM.get()), (LevelAccessor)worldGenLevel, MobSpawnType.SPAWNER, offset, worldGenLevel.getRandom())) {
                this.golemoverhaul$spawnAdditionalGolem(hayGolemEntityType, worldGenLevel, settings, offset);
            }
        });
    }

    @Unique
    private <T extends BaseGolem> void golemoverhaul$spawnAdditionalGolem(EntityType<T> entityType, WorldGenLevel worldGenLevel, StructurePlaceSettings settings, BlockPos offset) {
        BaseGolem golem = (BaseGolem)entityType.create((Level)worldGenLevel.getLevel());
        if (golem == null) {
            return;
        }
        Vec3 spawnPos = new Vec3((double)offset.getX() + 0.5, (double)(offset.getY() + 1), (double)offset.getZ() + 0.5);
        float yRot = golem.rotate(settings.getRotation());
        golem.moveTo(spawnPos.x, spawnPos.y, spawnPos.z, yRot += golem.mirror(settings.getMirror()) - golem.getYRot(), golem.getXRot());
        if (settings.shouldFinalizeEntities()) {
            golem.finalizeSpawn((ServerLevelAccessor)worldGenLevel, worldGenLevel.getCurrentDifficultyAt(BlockPos.containing((Position)spawnPos)), MobSpawnType.STRUCTURE, null);
        }
        worldGenLevel.addFreshEntityWithPassengers((Entity)golem);
    }
}

